/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.index.impl;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.elasticsearch.document.impl.ElasticsearchDocumentObjectBuilder;
import org.hibernate.search.backend.elasticsearch.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.util.impl.URLEncodedString;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWork;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWorkFactory;
import org.hibernate.search.engine.backend.index.spi.DocumentContributor;
import org.hibernate.search.engine.backend.index.spi.DocumentReferenceProvider;
import org.hibernate.search.engine.backend.index.spi.IndexWorkPlan;
import org.hibernate.search.engine.mapper.session.context.spi.SessionContextImplementor;

public class ElasticsearchIndexWorkPlan
implements IndexWorkPlan<ElasticsearchDocumentObjectBuilder> {
    private final ElasticsearchWorkFactory factory;
    private final MultiTenancyStrategy multiTenancyStrategy;
    private final ElasticsearchWorkOrchestrator orchestrator;
    private final URLEncodedString indexName;
    private final URLEncodedString typeName;
    private final String tenantId;
    private final List<ElasticsearchWork<?>> works = new ArrayList();

    ElasticsearchIndexWorkPlan(ElasticsearchWorkFactory factory, MultiTenancyStrategy multiTenancyStrategy, ElasticsearchWorkOrchestrator orchestrator, URLEncodedString indexName, URLEncodedString typeName, SessionContextImplementor sessionContext) {
        this.factory = factory;
        this.multiTenancyStrategy = multiTenancyStrategy;
        this.orchestrator = orchestrator;
        this.indexName = indexName;
        this.typeName = typeName;
        this.tenantId = sessionContext.getTenantIdentifier();
    }

    public void add(DocumentReferenceProvider referenceProvider, DocumentContributor<ElasticsearchDocumentObjectBuilder> documentContributor) {
        String id = referenceProvider.getIdentifier();
        String elasticsearchId = this.multiTenancyStrategy.toElasticsearchId(this.tenantId, id);
        String routingKey = referenceProvider.getRoutingKey();
        ElasticsearchDocumentObjectBuilder builder = new ElasticsearchDocumentObjectBuilder();
        documentContributor.contribute((Object)builder);
        JsonObject document = builder.build(this.multiTenancyStrategy, this.tenantId, id);
        this.collect(this.factory.add(this.indexName, this.typeName, elasticsearchId, routingKey, document));
    }

    public void update(DocumentReferenceProvider referenceProvider, DocumentContributor<ElasticsearchDocumentObjectBuilder> documentContributor) {
        String id = referenceProvider.getIdentifier();
        String elasticsearchId = this.multiTenancyStrategy.toElasticsearchId(this.tenantId, id);
        String routingKey = referenceProvider.getRoutingKey();
        ElasticsearchDocumentObjectBuilder builder = new ElasticsearchDocumentObjectBuilder();
        documentContributor.contribute((Object)builder);
        JsonObject document = builder.build(this.multiTenancyStrategy, this.tenantId, id);
        this.collect(this.factory.update(this.indexName, this.typeName, elasticsearchId, routingKey, document));
    }

    public void delete(DocumentReferenceProvider referenceProvider) {
        String elasticsearchId = this.multiTenancyStrategy.toElasticsearchId(this.tenantId, referenceProvider.getIdentifier());
        String routingKey = referenceProvider.getRoutingKey();
        this.collect(this.factory.delete(this.indexName, this.typeName, elasticsearchId, routingKey));
    }

    public void prepare() {
    }

    public CompletableFuture<?> execute() {
        try {
            CompletableFuture<?> future;
            CompletableFuture<?> completableFuture = future = this.orchestrator.submit(this.works);
            return completableFuture;
        }
        finally {
            this.works.clear();
        }
    }

    private void collect(ElasticsearchWork<?> work) {
        this.works.add(work);
    }
}

