/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.index.impl;

import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.elasticsearch.client.impl.ElasticsearchClient;
import org.hibernate.search.backend.elasticsearch.document.impl.ElasticsearchDocumentObjectBuilder;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexModel;
import org.hibernate.search.backend.elasticsearch.index.impl.ElasticsearchIndexWorkPlan;
import org.hibernate.search.backend.elasticsearch.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchStubWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.util.impl.URLEncodedString;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWork;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWorkFactory;
import org.hibernate.search.engine.backend.index.spi.IndexWorkPlan;
import org.hibernate.search.engine.mapper.session.context.spi.SessionContextImplementor;
import org.hibernate.search.util.EventContext;

public class IndexingBackendContext {
    private final EventContext eventContext;
    private final ElasticsearchClient client;
    private final ElasticsearchWorkFactory workFactory;
    private final MultiTenancyStrategy multiTenancyStrategy;
    private final ElasticsearchWorkOrchestrator streamOrchestrator;

    public IndexingBackendContext(EventContext eventContext, ElasticsearchClient client, ElasticsearchWorkFactory workFactory, MultiTenancyStrategy multiTenancyStrategy, ElasticsearchWorkOrchestrator streamOrchestrator) {
        this.eventContext = eventContext;
        this.client = client;
        this.multiTenancyStrategy = multiTenancyStrategy;
        this.workFactory = workFactory;
        this.streamOrchestrator = streamOrchestrator;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.eventContext + "]";
    }

    EventContext getEventContext() {
        return this.eventContext;
    }

    CompletableFuture<?> initializeIndex(URLEncodedString indexName, URLEncodedString typeName, ElasticsearchIndexModel model) {
        ElasticsearchWork<?> dropWork = this.workFactory.dropIndexIfExists(indexName);
        ElasticsearchWork<?> createWork = this.workFactory.createIndex(indexName, typeName, model.getMapping(), model.getSettings());
        return this.streamOrchestrator.submit(Arrays.asList(dropWork, createWork));
    }

    ElasticsearchWorkOrchestrator createWorkPlanOrchestrator() {
        return new ElasticsearchStubWorkOrchestrator(this.client);
    }

    IndexWorkPlan<ElasticsearchDocumentObjectBuilder> createWorkPlan(ElasticsearchWorkOrchestrator orchestrator, URLEncodedString indexName, URLEncodedString typeName, SessionContextImplementor sessionContext) {
        this.multiTenancyStrategy.checkTenantId(sessionContext.getTenantIdentifier(), this.eventContext);
        return new ElasticsearchIndexWorkPlan(this.workFactory, this.multiTenancyStrategy, orchestrator, indexName, typeName, sessionContext);
    }
}

