/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.index.settings.impl;

import org.hibernate.search.backend.elasticsearch.analysis.model.impl.ElasticsearchAnalysisDefinitionRegistry;
import org.hibernate.search.backend.elasticsearch.index.settings.impl.esnative.Analysis;
import org.hibernate.search.backend.elasticsearch.index.settings.impl.esnative.IndexSettings;

public class ElasticsearchIndexSettingsBuilder {
    private final ElasticsearchAnalysisDefinitionRegistry analysisDefinitionRegistry;

    public ElasticsearchIndexSettingsBuilder(ElasticsearchAnalysisDefinitionRegistry analysisDefinitionRegistry) {
        this.analysisDefinitionRegistry = analysisDefinitionRegistry;
    }

    public IndexSettings build() {
        IndexSettings settings = new IndexSettings();
        if (!this.analysisDefinitionRegistry.getAnalyzerDefinitions().isEmpty()) {
            this.getAnalysis(settings).setAnalyzers(this.analysisDefinitionRegistry.getAnalyzerDefinitions());
        }
        if (!this.analysisDefinitionRegistry.getNormalizerDefinitions().isEmpty()) {
            this.getAnalysis(settings).setNormalizers(this.analysisDefinitionRegistry.getNormalizerDefinitions());
        }
        if (!this.analysisDefinitionRegistry.getTokenizerDefinitions().isEmpty()) {
            this.getAnalysis(settings).setTokenizers(this.analysisDefinitionRegistry.getTokenizerDefinitions());
        }
        if (!this.analysisDefinitionRegistry.getTokenFilterDefinitions().isEmpty()) {
            this.getAnalysis(settings).setTokenFilters(this.analysisDefinitionRegistry.getTokenFilterDefinitions());
        }
        if (!this.analysisDefinitionRegistry.getCharFilterDefinitions().isEmpty()) {
            this.getAnalysis(settings).setCharFilters(this.analysisDefinitionRegistry.getCharFilterDefinitions());
        }
        return settings;
    }

    private Analysis getAnalysis(IndexSettings settings) {
        Analysis analysis = settings.getAnalysis();
        if (analysis == null) {
            analysis = new Analysis();
            settings.setAnalysis(analysis);
        }
        return analysis;
    }
}

