/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.logging.impl;

import com.google.gson.JsonElement;
import java.util.Map;
import org.hibernate.search.backend.elasticsearch.index.ElasticsearchIndexManager;
import org.hibernate.search.backend.elasticsearch.types.predicate.impl.ElasticsearchFieldPredicateBuilderFactory;
import org.hibernate.search.backend.elasticsearch.types.projection.impl.ElasticsearchFieldProjectionBuilderFactory;
import org.hibernate.search.backend.elasticsearch.types.sort.impl.ElasticsearchFieldSortBuilderFactory;
import org.hibernate.search.engine.backend.index.spi.IndexSearchTargetContextBuilder;
import org.hibernate.search.engine.search.SearchPredicate;
import org.hibernate.search.engine.search.SearchProjection;
import org.hibernate.search.engine.search.SearchSort;
import org.hibernate.search.util.AssertionFailure;
import org.hibernate.search.util.EventContext;
import org.hibernate.search.util.SearchException;
import org.hibernate.search.util.impl.common.logging.ClassFormatter;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.FormatWith;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Param;
import org.jboss.logging.annotations.ValidIdRange;
import org.jboss.logging.annotations.ValidIdRanges;

@MessageLogger(projectCode="HSEARCH")
@ValidIdRanges(value={@ValidIdRange(min=400000, max=409999)})
public interface Log
extends BasicLogger {
    public static final int ID_OFFSET_1 = 0;
    public static final int ID_OFFSET_2 = 400000;
    public static final int ID_OFFSET_3 = 400500;

    @Message(id=400055, value="Multiple tokenizer definitions with the same name: '%1$s'. The tokenizer names must be unique.")
    public SearchException tokenizerNamingConflict(String var1);

    @Message(id=400056, value="Multiple char filter definitions with the same name: '%1$s'. The char filter names must be unique.")
    public SearchException charFilterNamingConflict(String var1);

    @Message(id=400057, value="Multiple token filter definitions with the same name: '%1$s'. The token filter names must be unique.")
    public SearchException tokenFilterNamingConflict(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=400073, value="Hibernate Search will connect to Elasticsearch server '%1$s' with authentication over plain HTTP (not HTTPS). The password will be sent in clear text over the network.")
    public void usingPasswordOverHttp(String var1);

    @Message(id=400074, value="Multiple analyzer definitions with the same name: '%1$s'. The analyzer names must be unique.")
    public SearchException analyzerNamingConflict(String var1);

    @Message(id=400075, value="Error while applying analysis configuration: %1$s")
    public SearchException unableToApplyAnalysisConfiguration(String var1, @Param EventContext var2, @Cause Exception var3);

    @Message(id=400076, value="Invalid analyzer definition for name '%1$s'. Analyzer definitions must at least define the tokenizer.")
    public SearchException invalidElasticsearchAnalyzerDefinition(String var1);

    @Message(id=400077, value="Invalid tokenizer definition for name '%1$s'. Tokenizer definitions must at least define the tokenizer type.")
    public SearchException invalidElasticsearchTokenizerDefinition(String var1);

    @Message(id=400078, value="Invalid char filter definition for name '%1$s'. Char filter definitions must at least define the char filter type.")
    public SearchException invalidElasticsearchCharFilterDefinition(String var1);

    @Message(id=400079, value="Invalid token filter definition for name '%1$s'. Token filter definitions must at least define the token filter type.")
    public SearchException invalidElasticsearchTokenFilterDefinition(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=400082, value="Executed Elasticsearch HTTP %s request to path '%s' with query parameters %s in %dms. Response had status %d '%s'.")
    public void executedRequest(String var1, String var2, Map<String, String> var3, long var4, int var6, String var7);

    @Message(id=400086, value="Multiple normalizer definitions with the same name: '%1$s'. The normalizer names must be unique.")
    public SearchException normalizerNamingConflict(String var1);

    @Message(id=400089, value="Failed to parse Elasticsearch response. Status code was '%1$d', status phrase was '%2$s'.")
    public SearchException failedToParseElasticsearchResponse(int var1, String var2, @Cause Exception var3);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=400093, value="Executed Elasticsearch HTTP %s request to path '%s' with query parameters %s in %dms. Response had status %d '%s'. Request body: <%s>. Response body: <%s>")
    public void executedRequest(String var1, String var2, Map<String, String> var3, long var4, int var6, String var7, String var8, String var9);

    @Message(id=400502, value="A search query cannot target both an Elasticsearch index and other types of index. First target was: '%1$s', other target was: '%2$s'")
    public SearchException cannotMixElasticsearchSearchTargetWithOtherType(IndexSearchTargetContextBuilder var1, ElasticsearchIndexManager var2, @Param EventContext var3);

    @Message(id=400503, value="A search query cannot target multiple Elasticsearch backends. First target was: '%1$s', other target was: '%2$s'")
    public SearchException cannotMixElasticsearchSearchTargetWithOtherBackend(IndexSearchTargetContextBuilder var1, ElasticsearchIndexManager var2, @Param EventContext var3);

    @Message(id=400504, value="Unknown field '%1$s'.")
    public SearchException unknownFieldForSearch(String var1, @Param EventContext var2);

    @Message(id=400506, value="The Elasticsearch extension can only be applied to objects derived from the Elasticsearch backend. Was applied to '%1$s' instead.")
    public SearchException elasticsearchExtensionOnUnknownType(Object var1);

    @Message(id=400507, value="Invalid projection on unknown field '%1$s'.")
    public SearchException invalidProjectionUnknownField(String var1, @Param EventContext var2);

    @Message(id=400508, value="An Elasticsearch query cannot include search predicates built using a non-Elasticsearch search target. Given predicate was: '%1$s'")
    public SearchException cannotMixElasticsearchSearchQueryWithOtherPredicates(SearchPredicate var1);

    @Message(id=400509, value="Field '%1$s' is not an object field.")
    public SearchException nonObjectFieldForNestedQuery(String var1, @Param EventContext var2);

    @Message(id=400510, value="Object field '%1$s' is not stored as nested.")
    public SearchException nonNestedFieldForNestedQuery(String var1, @Param EventContext var2);

    @Message(id=400511, value="An Elasticsearch query cannot include search sorts built using a non-Elasticsearch search target. Given sort was: '%1$s'")
    public SearchException cannotMixElasticsearchSearchSortWithOtherSorts(SearchSort var1);

    @Message(id=400514, value="Index '%1$s' requires multi-tenancy but the backend does not support it in its current configuration.")
    public SearchException multiTenancyRequiredButNotSupportedByBackend(String var1, @Param EventContext var2);

    @Message(id=400515, value="Unknown multi-tenancy strategy '%1$s'.")
    public SearchException unknownMultiTenancyStrategyConfiguration(String var1);

    @Message(id=400516, value="Tenant identifier '%1$s' is provided, but multi-tenancy is disabled for this backend.")
    public SearchException tenantIdProvidedButMultiTenancyDisabled(String var1, @Param EventContext var2);

    @Message(id=400517, value="Backend has multi-tenancy enabled, but no tenant identifier is provided.")
    public SearchException multiTenancyEnabledButNoTenantIdProvided(@Param EventContext var1);

    @Message(id=400518, value="Attempt to unwrap the Elasticsearch low-level client to %1$s, but the client can only be unwrapped to %2$s.")
    public SearchException clientUnwrappingWithUnkownType(Class<?> var1, Class<?> var2);

    @Message(id=400519, value="Attempt to unwrap an Elasticsearch backend to '%1$s', but this backend can only be unwrapped to '%2$s'.")
    public SearchException backendUnwrappingWithUnknownType(@FormatWith(value=ClassFormatter.class) Class<?> var1, @FormatWith(value=ClassFormatter.class) Class<?> var2, @Param EventContext var3);

    @Message(id=400520, value="The index schema node '%1$s' was added twice. Multiple bridges may be trying to access the same index field,  or two indexed-embeddeds may have prefixes that lead to conflicting field names, or you may have declared multiple conflicting mappings. In any case, there is something wrong with your mapping and you should fix it.")
    public SearchException indexSchemaNodeNameConflict(String var1, @Param EventContext var2);

    @Message(id=400523, value="Range predicates are not supported by the GeoPoint field type, use spatial predicates instead.")
    public SearchException rangePredicatesNotSupportedByGeoPoint(@Param EventContext var1);

    @Message(id=400524, value="Match predicates are not supported by the GeoPoint field type, use spatial predicates instead.")
    public SearchException matchPredicatesNotSupportedByGeoPoint(@Param EventContext var1);

    @Message(id=400525, value="Invalid parent object for this field accessor; expected path '%1$s', got '%2$s'.")
    public SearchException invalidParentDocumentObjectState(String var1, String var2);

    @Message(id=400526, value="Expected data was missing in the Elasticsearch response.")
    public AssertionFailure elasticsearchResponseMissingData();

    @Message(id=400527, value="Spatial predicates are not supported by this field's type.")
    public SearchException spatialPredicatesNotSupportedByFieldType(@Param EventContext var1);

    @Message(id=400528, value="Distance related operations are not supported by this field's type.")
    public SearchException distanceOperationsNotSupportedByFieldType(@Param EventContext var1);

    @Message(id=400529, value="Multiple conflicting minimumShouldMatch constraints for ceiling '%1$s'")
    public SearchException minimumShouldMatchConflictingConstraints(int var1);

    @Message(id=400530, value="Duplicate index names when normalized to conform to Elasticsearch rules: '%1$s' and '%2$s' both become '%3$s'")
    public SearchException duplicateNormalizedIndexNames(String var1, String var2, String var3, @Param EventContext var4);

    @Message(id=400531, value="Unknown index name encountered in Elasticsearch response: '%1$s'")
    public SearchException elasticsearchResponseUnknownIndexName(String var1, @Param EventContext var2);

    @Message(id=400532, value="Unable to convert DSL parameter: %1$s")
    public SearchException cannotConvertDslParameter(String var1, @Cause Exception var2, @Param EventContext var3);

    @Message(id=400533, value="Attempt to unwrap an Elasticsearch index manager to '%1$s', but this index manager can only be unwrapped to '%2$s'.")
    public SearchException indexManagerUnwrappingWithUnknownType(@FormatWith(value=ClassFormatter.class) Class<?> var1, @FormatWith(value=ClassFormatter.class) Class<?> var2, @Param EventContext var3);

    @Message(id=400534, value="Invalid typed analyzer definition for name '%1$s'. Typed analyzer definitions must at least define the analyzer type.")
    public SearchException invalidElasticsearchTypedAnalyzerDefinition(String var1);

    @Message(id=400535, value="Cannot apply both an analyzer and a normalizer. Analyzer: '%1$s', normalizer: '%2$s'.")
    public SearchException cannotApplyAnalyzerAndNormalizer(String var1, String var2, @Param EventContext var3);

    @Message(id=400536, value="Cannot apply an analyzer on a sortable field. Use a normalizer instead. Analyzer: '%1$s'. If an actual analyzer (with tokenization) is necessary, define two separate fields: one with an analyzer that is not sortable, and one with a normalizer that is sortable.")
    public SearchException cannotUseAnalyzerOnSortableField(String var1, @Param EventContext var2);

    @Message(id=400537, value="Multiple parameters with the same name: '%1$s'. Can't assign both value '%2$s' and '%3$s'")
    public SearchException analysisComponentParameterConflict(String var1, JsonElement var2, JsonElement var3);

    @Message(id=400538, value="An Elasticsearch query cannot include search projections built using a non-Elasticsearch search target. Given projection was: '%1$s'")
    public SearchException cannotMixElasticsearchSearchQueryWithOtherProjections(SearchProjection<?> var1);

    @Message(id=400539, value="Invalid type '%2$s' for projection on field '%1$s'.")
    public SearchException invalidProjectionInvalidType(String var1, @FormatWith(value=ClassFormatter.class) Class<?> var2, @Param EventContext var3);

    @Message(id=400540, value="Traditional sorting operations are not supported by the GeoPoint field type, use distance sorting instead.")
    public SearchException traditionalSortNotSupportedByGeoPoint(@Param EventContext var1);

    @Message(id=400541, value="Multiple conflicting types to build a predicate for field '%1$s': '%2$s' vs. '%3$s'.")
    public SearchException conflictingFieldTypesForPredicate(String var1, ElasticsearchFieldPredicateBuilderFactory var2, ElasticsearchFieldPredicateBuilderFactory var3, @Param EventContext var4);

    @Message(id=400542, value="Multiple conflicting types to build a sort for field '%1$s': '%2$s' vs. '%3$s'.")
    public SearchException conflictingFieldTypesForSort(String var1, ElasticsearchFieldSortBuilderFactory var2, ElasticsearchFieldSortBuilderFactory var3, @Param EventContext var4);

    @Message(id=400543, value="Multiple conflicting types to build a projection for field '%1$s': '%2$s' vs. '%3$s'.")
    public SearchException conflictingFieldTypesForProjection(String var1, ElasticsearchFieldProjectionBuilderFactory var2, ElasticsearchFieldProjectionBuilderFactory var3, @Param EventContext var4);

    @Message(id=400544, value="Failed to shut down the Elasticsearch backend.")
    public SearchException failedToShutdownBackend(@Cause Exception var1, @Param EventContext var2);

    @Message(id=400545, value="Cannot guess field type for input type %1$s.")
    public SearchException cannotGuessFieldType(@FormatWith(value=ClassFormatter.class) Class<?> var1, @Param EventContext var2);

    @Message(id=400546, value="You cannot set the type of a field more than once.")
    public SearchException tryToSetFieldTypeMoreThanOnce(@Param EventContext var1);

    @Message(id=400547, value="Projections are not enabled for field '%1$s'. Make sure the field is marked as projectable.")
    public SearchException nonProjectableField(String var1, @Param EventContext var2);

    @Message(id=400548, value="Sorting is not enabled for field '%1$s'. Make sure the field is marked as sortable.")
    public SearchException unsortableField(String var1, @Param EventContext var2);
}

