/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.logging.impl;

import com.google.gson.JsonElement;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import org.hibernate.search.backend.elasticsearch.index.ElasticsearchIndexManager;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.types.predicate.impl.ElasticsearchFieldPredicateBuilderFactory;
import org.hibernate.search.backend.elasticsearch.types.projection.impl.ElasticsearchFieldProjectionBuilderFactory;
import org.hibernate.search.backend.elasticsearch.types.sort.impl.ElasticsearchFieldSortBuilderFactory;
import org.hibernate.search.engine.backend.index.spi.IndexSearchTargetContextBuilder;
import org.hibernate.search.engine.search.SearchPredicate;
import org.hibernate.search.engine.search.SearchProjection;
import org.hibernate.search.engine.search.SearchSort;
import org.hibernate.search.util.AssertionFailure;
import org.hibernate.search.util.EventContext;
import org.hibernate.search.util.SearchException;
import org.hibernate.search.util.impl.common.logging.ClassFormatter;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class Log_$logger
extends DelegatingBasicLogger
implements Log,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;
    private static final String tokenizerNamingConflict = "HSEARCH400055: Multiple tokenizer definitions with the same name: '%1$s'. The tokenizer names must be unique.";
    private static final String charFilterNamingConflict = "HSEARCH400056: Multiple char filter definitions with the same name: '%1$s'. The char filter names must be unique.";
    private static final String tokenFilterNamingConflict = "HSEARCH400057: Multiple token filter definitions with the same name: '%1$s'. The token filter names must be unique.";
    private static final String usingPasswordOverHttp = "HSEARCH400073: Hibernate Search will connect to Elasticsearch server '%1$s' with authentication over plain HTTP (not HTTPS). The password will be sent in clear text over the network.";
    private static final String analyzerNamingConflict = "HSEARCH400074: Multiple analyzer definitions with the same name: '%1$s'. The analyzer names must be unique.";
    private static final String unableToApplyAnalysisConfiguration = "HSEARCH400075: Error while applying analysis configuration: %1$s";
    private static final String invalidElasticsearchAnalyzerDefinition = "HSEARCH400076: Invalid analyzer definition for name '%1$s'. Analyzer definitions must at least define the tokenizer.";
    private static final String invalidElasticsearchTokenizerDefinition = "HSEARCH400077: Invalid tokenizer definition for name '%1$s'. Tokenizer definitions must at least define the tokenizer type.";
    private static final String invalidElasticsearchCharFilterDefinition = "HSEARCH400078: Invalid char filter definition for name '%1$s'. Char filter definitions must at least define the char filter type.";
    private static final String invalidElasticsearchTokenFilterDefinition = "HSEARCH400079: Invalid token filter definition for name '%1$s'. Token filter definitions must at least define the token filter type.";
    private static final String executedRequest6 = "HSEARCH400082: Executed Elasticsearch HTTP %s request to path '%s' with query parameters %s in %dms. Response had status %d '%s'.";
    private static final String normalizerNamingConflict = "HSEARCH400086: Multiple normalizer definitions with the same name: '%1$s'. The normalizer names must be unique.";
    private static final String failedToParseElasticsearchResponse = "HSEARCH400089: Failed to parse Elasticsearch response. Status code was '%1$d', status phrase was '%2$s'.";
    private static final String executedRequest8 = "HSEARCH400093: Executed Elasticsearch HTTP %s request to path '%s' with query parameters %s in %dms. Response had status %d '%s'. Request body: <%s>. Response body: <%s>";
    private static final String cannotMixElasticsearchSearchTargetWithOtherType = "HSEARCH400502: A search query cannot target both an Elasticsearch index and other types of index. First target was: '%1$s', other target was: '%2$s'";
    private static final String cannotMixElasticsearchSearchTargetWithOtherBackend = "HSEARCH400503: A search query cannot target multiple Elasticsearch backends. First target was: '%1$s', other target was: '%2$s'";
    private static final String unknownFieldForSearch = "HSEARCH400504: Unknown field '%1$s'.";
    private static final String elasticsearchExtensionOnUnknownType = "HSEARCH400506: The Elasticsearch extension can only be applied to objects derived from the Elasticsearch backend. Was applied to '%1$s' instead.";
    private static final String invalidProjectionUnknownField = "HSEARCH400507: Invalid projection on unknown field '%1$s'.";
    private static final String cannotMixElasticsearchSearchQueryWithOtherPredicates = "HSEARCH400508: An Elasticsearch query cannot include search predicates built using a non-Elasticsearch search target. Given predicate was: '%1$s'";
    private static final String nonObjectFieldForNestedQuery = "HSEARCH400509: Field '%1$s' is not an object field.";
    private static final String nonNestedFieldForNestedQuery = "HSEARCH400510: Object field '%1$s' is not stored as nested.";
    private static final String cannotMixElasticsearchSearchSortWithOtherSorts = "HSEARCH400511: An Elasticsearch query cannot include search sorts built using a non-Elasticsearch search target. Given sort was: '%1$s'";
    private static final String multiTenancyRequiredButNotSupportedByBackend = "HSEARCH400514: Index '%1$s' requires multi-tenancy but the backend does not support it in its current configuration.";
    private static final String unknownMultiTenancyStrategyConfiguration = "HSEARCH400515: Unknown multi-tenancy strategy '%1$s'.";
    private static final String tenantIdProvidedButMultiTenancyDisabled = "HSEARCH400516: Tenant identifier '%1$s' is provided, but multi-tenancy is disabled for this backend.";
    private static final String multiTenancyEnabledButNoTenantIdProvided = "HSEARCH400517: Backend has multi-tenancy enabled, but no tenant identifier is provided.";
    private static final String clientUnwrappingWithUnkownType = "HSEARCH400518: Attempt to unwrap the Elasticsearch low-level client to %1$s, but the client can only be unwrapped to %2$s.";
    private static final String backendUnwrappingWithUnknownType = "HSEARCH400519: Attempt to unwrap an Elasticsearch backend to '%1$s', but this backend can only be unwrapped to '%2$s'.";
    private static final String indexSchemaNodeNameConflict = "HSEARCH400520: The index schema node '%1$s' was added twice. Multiple bridges may be trying to access the same index field,  or two indexed-embeddeds may have prefixes that lead to conflicting field names, or you may have declared multiple conflicting mappings. In any case, there is something wrong with your mapping and you should fix it.";
    private static final String rangePredicatesNotSupportedByGeoPoint = "HSEARCH400523: Range predicates are not supported by the GeoPoint field type, use spatial predicates instead.";
    private static final String matchPredicatesNotSupportedByGeoPoint = "HSEARCH400524: Match predicates are not supported by the GeoPoint field type, use spatial predicates instead.";
    private static final String invalidParentDocumentObjectState = "HSEARCH400525: Invalid parent object for this field accessor; expected path '%1$s', got '%2$s'.";
    private static final String elasticsearchResponseMissingData = "HSEARCH400526: Expected data was missing in the Elasticsearch response.";
    private static final String spatialPredicatesNotSupportedByFieldType = "HSEARCH400527: Spatial predicates are not supported by this field's type.";
    private static final String distanceOperationsNotSupportedByFieldType = "HSEARCH400528: Distance related operations are not supported by this field's type.";
    private static final String minimumShouldMatchConflictingConstraints = "HSEARCH400529: Multiple conflicting minimumShouldMatch constraints for ceiling '%1$s'";
    private static final String duplicateNormalizedIndexNames = "HSEARCH400530: Duplicate index names when normalized to conform to Elasticsearch rules: '%1$s' and '%2$s' both become '%3$s'";
    private static final String elasticsearchResponseUnknownIndexName = "HSEARCH400531: Unknown index name encountered in Elasticsearch response: '%1$s'";
    private static final String cannotConvertDslParameter = "HSEARCH400532: Unable to convert DSL parameter: %1$s";
    private static final String indexManagerUnwrappingWithUnknownType = "HSEARCH400533: Attempt to unwrap an Elasticsearch index manager to '%1$s', but this index manager can only be unwrapped to '%2$s'.";
    private static final String invalidElasticsearchTypedAnalyzerDefinition = "HSEARCH400534: Invalid typed analyzer definition for name '%1$s'. Typed analyzer definitions must at least define the analyzer type.";
    private static final String cannotApplyAnalyzerAndNormalizer = "HSEARCH400535: Cannot apply both an analyzer and a normalizer. Analyzer: '%1$s', normalizer: '%2$s'.";
    private static final String cannotUseAnalyzerOnSortableField = "HSEARCH400536: Cannot apply an analyzer on a sortable field. Use a normalizer instead. Analyzer: '%1$s'. If an actual analyzer (with tokenization) is necessary, define two separate fields: one with an analyzer that is not sortable, and one with a normalizer that is sortable.";
    private static final String analysisComponentParameterConflict = "HSEARCH400537: Multiple parameters with the same name: '%1$s'. Can't assign both value '%2$s' and '%3$s'";
    private static final String cannotMixElasticsearchSearchQueryWithOtherProjections = "HSEARCH400538: An Elasticsearch query cannot include search projections built using a non-Elasticsearch search target. Given projection was: '%1$s'";
    private static final String invalidProjectionInvalidType = "HSEARCH400539: Invalid type '%2$s' for projection on field '%1$s'.";
    private static final String traditionalSortNotSupportedByGeoPoint = "HSEARCH400540: Traditional sorting operations are not supported by the GeoPoint field type, use distance sorting instead.";
    private static final String conflictingFieldTypesForPredicate = "HSEARCH400541: Multiple conflicting types to build a predicate for field '%1$s': '%2$s' vs. '%3$s'.";
    private static final String conflictingFieldTypesForSort = "HSEARCH400542: Multiple conflicting types to build a sort for field '%1$s': '%2$s' vs. '%3$s'.";
    private static final String conflictingFieldTypesForProjection = "HSEARCH400543: Multiple conflicting types to build a projection for field '%1$s': '%2$s' vs. '%3$s'.";
    private static final String failedToShutdownBackend = "HSEARCH400544: Failed to shut down the Elasticsearch backend.";
    private static final String cannotGuessFieldType = "HSEARCH400545: Cannot guess field type for input type %1$s.";
    private static final String tryToSetFieldTypeMoreThanOnce = "HSEARCH400546: You cannot set the type of a field more than once.";
    private static final String nonProjectableField = "HSEARCH400547: Projections are not enabled for field '%1$s'. Make sure the field is marked as projectable.";
    private static final String unsortableField = "HSEARCH400548: Sorting is not enabled for field '%1$s'. Make sure the field is marked as sortable.";

    public Log_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String tokenizerNamingConflict$str() {
        return tokenizerNamingConflict;
    }

    @Override
    public final SearchException tokenizerNamingConflict(String remoteName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.tokenizerNamingConflict$str(), remoteName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String charFilterNamingConflict$str() {
        return charFilterNamingConflict;
    }

    @Override
    public final SearchException charFilterNamingConflict(String remoteName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.charFilterNamingConflict$str(), remoteName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String tokenFilterNamingConflict$str() {
        return tokenFilterNamingConflict;
    }

    @Override
    public final SearchException tokenFilterNamingConflict(String remoteName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.tokenFilterNamingConflict$str(), remoteName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void usingPasswordOverHttp(String serverUris) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.usingPasswordOverHttp$str(), (Object)serverUris);
    }

    protected String usingPasswordOverHttp$str() {
        return usingPasswordOverHttp;
    }

    protected String analyzerNamingConflict$str() {
        return analyzerNamingConflict;
    }

    @Override
    public final SearchException analyzerNamingConflict(String remoteName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.analyzerNamingConflict$str(), remoteName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToApplyAnalysisConfiguration$str() {
        return unableToApplyAnalysisConfiguration;
    }

    @Override
    public final SearchException unableToApplyAnalysisConfiguration(String errorMessage, EventContext context, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToApplyAnalysisConfiguration$str(), errorMessage), (Throwable)e, context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidElasticsearchAnalyzerDefinition$str() {
        return invalidElasticsearchAnalyzerDefinition;
    }

    @Override
    public final SearchException invalidElasticsearchAnalyzerDefinition(String name) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidElasticsearchAnalyzerDefinition$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidElasticsearchTokenizerDefinition$str() {
        return invalidElasticsearchTokenizerDefinition;
    }

    @Override
    public final SearchException invalidElasticsearchTokenizerDefinition(String name) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidElasticsearchTokenizerDefinition$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidElasticsearchCharFilterDefinition$str() {
        return invalidElasticsearchCharFilterDefinition;
    }

    @Override
    public final SearchException invalidElasticsearchCharFilterDefinition(String name) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidElasticsearchCharFilterDefinition$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidElasticsearchTokenFilterDefinition$str() {
        return invalidElasticsearchTokenFilterDefinition;
    }

    @Override
    public final SearchException invalidElasticsearchTokenFilterDefinition(String name) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidElasticsearchTokenFilterDefinition$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void executedRequest(String method, String path, Map<String, String> getParameters, long timeInMs, int responseStatusCode, String responseStatusMessage) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.executedRequest6$str(), new Object[]{method, path, getParameters, timeInMs, responseStatusCode, responseStatusMessage});
    }

    protected String executedRequest6$str() {
        return executedRequest6;
    }

    protected String normalizerNamingConflict$str() {
        return normalizerNamingConflict;
    }

    @Override
    public final SearchException normalizerNamingConflict(String remoteName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.normalizerNamingConflict$str(), remoteName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failedToParseElasticsearchResponse$str() {
        return failedToParseElasticsearchResponse;
    }

    @Override
    public final SearchException failedToParseElasticsearchResponse(int statusCode, String statusPhrase, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.failedToParseElasticsearchResponse$str(), statusCode, statusPhrase), (Throwable)cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void executedRequest(String method, String path, Map<String, String> getParameters, long timeInMs, int responseStatusCode, String responseStatusMessage, String requestBodyParts, String responseBody) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.executedRequest8$str(), new Object[]{method, path, getParameters, timeInMs, responseStatusCode, responseStatusMessage, requestBodyParts, responseBody});
    }

    protected String executedRequest8$str() {
        return executedRequest8;
    }

    protected String cannotMixElasticsearchSearchTargetWithOtherType$str() {
        return cannotMixElasticsearchSearchTargetWithOtherType;
    }

    @Override
    public final SearchException cannotMixElasticsearchSearchTargetWithOtherType(IndexSearchTargetContextBuilder firstTarget, ElasticsearchIndexManager otherTarget, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotMixElasticsearchSearchTargetWithOtherType$str(), firstTarget, otherTarget), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotMixElasticsearchSearchTargetWithOtherBackend$str() {
        return cannotMixElasticsearchSearchTargetWithOtherBackend;
    }

    @Override
    public final SearchException cannotMixElasticsearchSearchTargetWithOtherBackend(IndexSearchTargetContextBuilder firstTarget, ElasticsearchIndexManager otherTarget, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotMixElasticsearchSearchTargetWithOtherBackend$str(), firstTarget, otherTarget), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownFieldForSearch$str() {
        return unknownFieldForSearch;
    }

    @Override
    public final SearchException unknownFieldForSearch(String absoluteFieldPath, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownFieldForSearch$str(), absoluteFieldPath), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String elasticsearchExtensionOnUnknownType$str() {
        return elasticsearchExtensionOnUnknownType;
    }

    @Override
    public final SearchException elasticsearchExtensionOnUnknownType(Object context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.elasticsearchExtensionOnUnknownType$str(), context));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidProjectionUnknownField$str() {
        return invalidProjectionUnknownField;
    }

    @Override
    public final SearchException invalidProjectionUnknownField(String absoluteFieldPath, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidProjectionUnknownField$str(), absoluteFieldPath), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotMixElasticsearchSearchQueryWithOtherPredicates$str() {
        return cannotMixElasticsearchSearchQueryWithOtherPredicates;
    }

    @Override
    public final SearchException cannotMixElasticsearchSearchQueryWithOtherPredicates(SearchPredicate predicate) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotMixElasticsearchSearchQueryWithOtherPredicates$str(), predicate));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nonObjectFieldForNestedQuery$str() {
        return nonObjectFieldForNestedQuery;
    }

    @Override
    public final SearchException nonObjectFieldForNestedQuery(String absoluteFieldPath, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.nonObjectFieldForNestedQuery$str(), absoluteFieldPath), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nonNestedFieldForNestedQuery$str() {
        return nonNestedFieldForNestedQuery;
    }

    @Override
    public final SearchException nonNestedFieldForNestedQuery(String absoluteFieldPath, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.nonNestedFieldForNestedQuery$str(), absoluteFieldPath), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotMixElasticsearchSearchSortWithOtherSorts$str() {
        return cannotMixElasticsearchSearchSortWithOtherSorts;
    }

    @Override
    public final SearchException cannotMixElasticsearchSearchSortWithOtherSorts(SearchSort sort) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotMixElasticsearchSearchSortWithOtherSorts$str(), sort));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String multiTenancyRequiredButNotSupportedByBackend$str() {
        return multiTenancyRequiredButNotSupportedByBackend;
    }

    @Override
    public final SearchException multiTenancyRequiredButNotSupportedByBackend(String indexName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.multiTenancyRequiredButNotSupportedByBackend$str(), indexName), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownMultiTenancyStrategyConfiguration$str() {
        return unknownMultiTenancyStrategyConfiguration;
    }

    @Override
    public final SearchException unknownMultiTenancyStrategyConfiguration(String multiTenancyStrategy) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownMultiTenancyStrategyConfiguration$str(), multiTenancyStrategy));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String tenantIdProvidedButMultiTenancyDisabled$str() {
        return tenantIdProvidedButMultiTenancyDisabled;
    }

    @Override
    public final SearchException tenantIdProvidedButMultiTenancyDisabled(String tenantId, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.tenantIdProvidedButMultiTenancyDisabled$str(), tenantId), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String multiTenancyEnabledButNoTenantIdProvided$str() {
        return multiTenancyEnabledButNoTenantIdProvided;
    }

    @Override
    public final SearchException multiTenancyEnabledButNoTenantIdProvided(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.multiTenancyEnabledButNoTenantIdProvided$str(), new Object[0]), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String clientUnwrappingWithUnkownType$str() {
        return clientUnwrappingWithUnkownType;
    }

    @Override
    public final SearchException clientUnwrappingWithUnkownType(Class<?> requestedClass, Class<?> actualClass) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.clientUnwrappingWithUnkownType$str(), requestedClass, actualClass));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String backendUnwrappingWithUnknownType$str() {
        return backendUnwrappingWithUnknownType;
    }

    @Override
    public final SearchException backendUnwrappingWithUnknownType(Class<?> requestedClass, Class<?> actualClass, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.backendUnwrappingWithUnknownType$str(), new ClassFormatter(requestedClass), new ClassFormatter(actualClass)), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String indexSchemaNodeNameConflict$str() {
        return indexSchemaNodeNameConflict;
    }

    @Override
    public final SearchException indexSchemaNodeNameConflict(String name, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.indexSchemaNodeNameConflict$str(), name), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String rangePredicatesNotSupportedByGeoPoint$str() {
        return rangePredicatesNotSupportedByGeoPoint;
    }

    @Override
    public final SearchException rangePredicatesNotSupportedByGeoPoint(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.rangePredicatesNotSupportedByGeoPoint$str(), new Object[0]), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String matchPredicatesNotSupportedByGeoPoint$str() {
        return matchPredicatesNotSupportedByGeoPoint;
    }

    @Override
    public final SearchException matchPredicatesNotSupportedByGeoPoint(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.matchPredicatesNotSupportedByGeoPoint$str(), new Object[0]), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidParentDocumentObjectState$str() {
        return invalidParentDocumentObjectState;
    }

    @Override
    public final SearchException invalidParentDocumentObjectState(String expectedPath, String actualPath) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidParentDocumentObjectState$str(), expectedPath, actualPath));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String elasticsearchResponseMissingData$str() {
        return elasticsearchResponseMissingData;
    }

    @Override
    public final AssertionFailure elasticsearchResponseMissingData() {
        AssertionFailure result = new AssertionFailure(String.format(this.getLoggingLocale(), this.elasticsearchResponseMissingData$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String spatialPredicatesNotSupportedByFieldType$str() {
        return spatialPredicatesNotSupportedByFieldType;
    }

    @Override
    public final SearchException spatialPredicatesNotSupportedByFieldType(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.spatialPredicatesNotSupportedByFieldType$str(), new Object[0]), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String distanceOperationsNotSupportedByFieldType$str() {
        return distanceOperationsNotSupportedByFieldType;
    }

    @Override
    public final SearchException distanceOperationsNotSupportedByFieldType(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.distanceOperationsNotSupportedByFieldType$str(), new Object[0]), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String minimumShouldMatchConflictingConstraints$str() {
        return minimumShouldMatchConflictingConstraints;
    }

    @Override
    public final SearchException minimumShouldMatchConflictingConstraints(int ceiling) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.minimumShouldMatchConflictingConstraints$str(), ceiling));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String duplicateNormalizedIndexNames$str() {
        return duplicateNormalizedIndexNames;
    }

    @Override
    public final SearchException duplicateNormalizedIndexNames(String firstHibernateSearchIndexName, String secondHibernateSearchIndexName, String elasticsearchIndexName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.duplicateNormalizedIndexNames$str(), firstHibernateSearchIndexName, secondHibernateSearchIndexName, elasticsearchIndexName), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String elasticsearchResponseUnknownIndexName$str() {
        return elasticsearchResponseUnknownIndexName;
    }

    @Override
    public final SearchException elasticsearchResponseUnknownIndexName(String elasticsearchIndexName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.elasticsearchResponseUnknownIndexName$str(), elasticsearchIndexName), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotConvertDslParameter$str() {
        return cannotConvertDslParameter;
    }

    @Override
    public final SearchException cannotConvertDslParameter(String errorMessage, Exception cause, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotConvertDslParameter$str(), errorMessage), (Throwable)cause, context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String indexManagerUnwrappingWithUnknownType$str() {
        return indexManagerUnwrappingWithUnknownType;
    }

    @Override
    public final SearchException indexManagerUnwrappingWithUnknownType(Class<?> requestedClass, Class<?> actualClass, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.indexManagerUnwrappingWithUnknownType$str(), new ClassFormatter(requestedClass), new ClassFormatter(actualClass)), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidElasticsearchTypedAnalyzerDefinition$str() {
        return invalidElasticsearchTypedAnalyzerDefinition;
    }

    @Override
    public final SearchException invalidElasticsearchTypedAnalyzerDefinition(String name) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidElasticsearchTypedAnalyzerDefinition$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotApplyAnalyzerAndNormalizer$str() {
        return cannotApplyAnalyzerAndNormalizer;
    }

    @Override
    public final SearchException cannotApplyAnalyzerAndNormalizer(String analyzerName, String normalizerName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotApplyAnalyzerAndNormalizer$str(), analyzerName, normalizerName), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotUseAnalyzerOnSortableField$str() {
        return cannotUseAnalyzerOnSortableField;
    }

    @Override
    public final SearchException cannotUseAnalyzerOnSortableField(String analyzerName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotUseAnalyzerOnSortableField$str(), analyzerName), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String analysisComponentParameterConflict$str() {
        return analysisComponentParameterConflict;
    }

    @Override
    public final SearchException analysisComponentParameterConflict(String name, JsonElement value1, JsonElement value2) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.analysisComponentParameterConflict$str(), name, value1, value2));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotMixElasticsearchSearchQueryWithOtherProjections$str() {
        return cannotMixElasticsearchSearchQueryWithOtherProjections;
    }

    @Override
    public final SearchException cannotMixElasticsearchSearchQueryWithOtherProjections(SearchProjection<?> projection) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotMixElasticsearchSearchQueryWithOtherProjections$str(), projection));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidProjectionInvalidType$str() {
        return invalidProjectionInvalidType;
    }

    @Override
    public final SearchException invalidProjectionInvalidType(String absoluteFieldPath, Class<?> type, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidProjectionInvalidType$str(), absoluteFieldPath, new ClassFormatter(type)), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String traditionalSortNotSupportedByGeoPoint$str() {
        return traditionalSortNotSupportedByGeoPoint;
    }

    @Override
    public final SearchException traditionalSortNotSupportedByGeoPoint(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.traditionalSortNotSupportedByGeoPoint$str(), new Object[0]), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String conflictingFieldTypesForPredicate$str() {
        return conflictingFieldTypesForPredicate;
    }

    @Override
    public final SearchException conflictingFieldTypesForPredicate(String absoluteFieldPath, ElasticsearchFieldPredicateBuilderFactory component1, ElasticsearchFieldPredicateBuilderFactory component2, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.conflictingFieldTypesForPredicate$str(), absoluteFieldPath, component1, component2), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String conflictingFieldTypesForSort$str() {
        return conflictingFieldTypesForSort;
    }

    @Override
    public final SearchException conflictingFieldTypesForSort(String absoluteFieldPath, ElasticsearchFieldSortBuilderFactory component1, ElasticsearchFieldSortBuilderFactory component2, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.conflictingFieldTypesForSort$str(), absoluteFieldPath, component1, component2), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String conflictingFieldTypesForProjection$str() {
        return conflictingFieldTypesForProjection;
    }

    @Override
    public final SearchException conflictingFieldTypesForProjection(String absoluteFieldPath, ElasticsearchFieldProjectionBuilderFactory component1, ElasticsearchFieldProjectionBuilderFactory component2, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.conflictingFieldTypesForProjection$str(), absoluteFieldPath, component1, component2), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failedToShutdownBackend$str() {
        return failedToShutdownBackend;
    }

    @Override
    public final SearchException failedToShutdownBackend(Exception cause, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.failedToShutdownBackend$str(), new Object[0]), (Throwable)cause, context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotGuessFieldType$str() {
        return cannotGuessFieldType;
    }

    @Override
    public final SearchException cannotGuessFieldType(Class<?> inputType, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotGuessFieldType$str(), new ClassFormatter(inputType)), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String tryToSetFieldTypeMoreThanOnce$str() {
        return tryToSetFieldTypeMoreThanOnce;
    }

    @Override
    public final SearchException tryToSetFieldTypeMoreThanOnce(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.tryToSetFieldTypeMoreThanOnce$str(), new Object[0]), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nonProjectableField$str() {
        return nonProjectableField;
    }

    @Override
    public final SearchException nonProjectableField(String absoluteFieldPath, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.nonProjectableField$str(), absoluteFieldPath), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsortableField$str() {
        return unsortableField;
    }

    @Override
    public final SearchException unsortableField(String absoluteFieldPath, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unsortableField$str(), absoluteFieldPath), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}

