/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.orchestration.impl;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.hibernate.search.backend.elasticsearch.client.impl.ElasticsearchClient;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchStubWorkExecutionContext;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWork;
import org.hibernate.search.util.impl.common.Futures;

public class ElasticsearchStubWorkOrchestrator
implements ElasticsearchWorkOrchestrator {
    private final ElasticsearchStubWorkExecutionContext context;
    private CompletableFuture<?> latestFuture = CompletableFuture.completedFuture(null);

    public ElasticsearchStubWorkOrchestrator(ElasticsearchClient client) {
        this.context = new ElasticsearchStubWorkExecutionContext(client);
    }

    @Override
    public void close() {
        this.latestFuture.join();
    }

    @Override
    public synchronized <T> CompletableFuture<T> submit(ElasticsearchWork<T> work) {
        CompletionStage future = this.latestFuture.thenCompose(Futures.safeComposer(ignored -> work.execute(this.context)));
        this.latestFuture = ((CompletableFuture)future).exceptionally(ignore -> null);
        return future;
    }

    @Override
    public synchronized CompletableFuture<?> submit(List<ElasticsearchWork<?>> works) {
        CompletionStage<Object> future = this.latestFuture;
        for (ElasticsearchWork<?> work : works) {
            future = future.thenCompose(Futures.safeComposer(ignored -> work.execute(this.context)));
        }
        this.latestFuture = future.exceptionally(ignore -> null);
        return future;
    }
}

