/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.impl;

import java.lang.invoke.MethodHandles;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexModel;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaFieldNode;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaObjectNode;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.search.impl.IndexSchemaFieldNodeComponentRetrievalStrategy;
import org.hibernate.search.backend.elasticsearch.util.impl.URLEncodedString;
import org.hibernate.search.engine.backend.document.model.dsl.ObjectFieldStorage;
import org.hibernate.search.engine.logging.spi.EventContexts;
import org.hibernate.search.util.EventContext;
import org.hibernate.search.util.impl.common.LoggerFactory;

public class ElasticsearchSearchTargetModel {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final Set<ElasticsearchIndexModel> indexModels;
    private final Set<String> hibernateSearchIndexNames;
    private final Set<URLEncodedString> elasticsearchIndexNames;

    public ElasticsearchSearchTargetModel(Set<ElasticsearchIndexModel> indexModels) {
        this.indexModels = indexModels;
        this.hibernateSearchIndexNames = indexModels.stream().map(ElasticsearchIndexModel::getHibernateSearchIndexName).collect(Collectors.toSet());
        this.elasticsearchIndexNames = indexModels.stream().map(ElasticsearchIndexModel::getElasticsearchIndexName).collect(Collectors.toSet());
    }

    public Set<String> getHibernateSearchIndexNames() {
        return this.hibernateSearchIndexNames;
    }

    public Set<URLEncodedString> getElasticsearchIndexNames() {
        return this.elasticsearchIndexNames;
    }

    public EventContext getIndexesEventContext() {
        return EventContexts.fromIndexNames(this.hibernateSearchIndexNames);
    }

    public Set<ElasticsearchIndexModel> getIndexModels() {
        return this.indexModels;
    }

    public <T> T getSchemaNodeComponent(String absoluteFieldPath, IndexSchemaFieldNodeComponentRetrievalStrategy<T> componentRetrievalStrategy) {
        ElasticsearchIndexModel indexModelForSelectedSchemaNode = null;
        ElasticsearchIndexSchemaFieldNode<?> selectedSchemaNode = null;
        Object selectedComponent = null;
        for (ElasticsearchIndexModel indexModel : this.indexModels) {
            ElasticsearchIndexSchemaFieldNode<?> schemaNode = indexModel.getFieldNode(absoluteFieldPath);
            if (schemaNode == null) continue;
            T component = componentRetrievalStrategy.extractComponent(schemaNode);
            if (selectedSchemaNode == null) {
                selectedSchemaNode = schemaNode;
                indexModelForSelectedSchemaNode = indexModel;
                selectedComponent = component;
                continue;
            }
            if (componentRetrievalStrategy.areCompatible(selectedComponent, component)) continue;
            throw componentRetrievalStrategy.createCompatibilityException(absoluteFieldPath, selectedComponent, component, EventContexts.fromIndexNames((String[])new String[]{indexModelForSelectedSchemaNode.getHibernateSearchIndexName(), indexModel.getHibernateSearchIndexName()}));
        }
        if (selectedSchemaNode == null) {
            throw log.unknownFieldForSearch(absoluteFieldPath, this.getIndexesEventContext());
        }
        return selectedComponent;
    }

    public void checkNestedField(String absoluteFieldPath) {
        ElasticsearchIndexSchemaFieldNode<?> schemaNode;
        boolean found = false;
        for (ElasticsearchIndexModel indexModel : this.indexModels) {
            schemaNode = indexModel.getObjectNode(absoluteFieldPath);
            if (schemaNode == null) continue;
            found = true;
            if (ObjectFieldStorage.NESTED.equals((Object)((ElasticsearchIndexSchemaObjectNode)((Object)schemaNode)).getStorage())) continue;
            throw log.nonNestedFieldForNestedQuery(absoluteFieldPath, indexModel.getEventContext());
        }
        if (!found) {
            for (ElasticsearchIndexModel indexModel : this.indexModels) {
                schemaNode = indexModel.getFieldNode(absoluteFieldPath);
                if (schemaNode == null) continue;
                throw log.nonObjectFieldForNestedQuery(absoluteFieldPath, indexModel.getEventContext());
            }
            throw log.unknownFieldForSearch(absoluteFieldPath, this.getIndexesEventContext());
        }
    }
}

