/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.predicate.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonObjectAccessor;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchContext;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.AbstractElasticsearchSearchPredicateBuilder;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.MatchIdPredicateBuilder;

public class ElasticsearchMatchIdPredicateBuilder
extends AbstractElasticsearchSearchPredicateBuilder
implements MatchIdPredicateBuilder<ElasticsearchSearchPredicateBuilder> {
    private static final JsonObjectAccessor IDS = JsonAccessor.root().property("ids").asObject();
    private static final JsonAccessor<JsonElement> VALUES = JsonAccessor.root().property("values");
    private List<String> values = new ArrayList<String>();

    public ElasticsearchMatchIdPredicateBuilder(ElasticsearchSearchContext searchContext) {
    }

    public void value(Object value) {
        this.values.add((String)value);
    }

    @Override
    protected JsonObject doBuild() {
        JsonArray array = this.convert(this.values);
        JsonObject inner = this.getInnerObject();
        VALUES.set(inner, (JsonElement)array);
        JsonObject outerObject = this.getOuterObject();
        IDS.set(outerObject, this.getInnerObject());
        return outerObject;
    }

    private JsonArray convert(List<String> list) {
        JsonArray jsonArray = new JsonArray(list.size());
        for (String value : list) {
            jsonArray.add(value);
        }
        return jsonArray;
    }
}

