/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.predicate.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.invoke.MethodHandles;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonObjectAccessor;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchContext;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.AbstractElasticsearchSearchPredicateBuilder;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicateBuilder;
import org.hibernate.search.backend.elasticsearch.types.converter.impl.ElasticsearchFieldConverter;
import org.hibernate.search.engine.logging.spi.EventContexts;
import org.hibernate.search.engine.search.predicate.spi.MatchPredicateBuilder;
import org.hibernate.search.util.impl.common.LoggerFactory;

public class ElasticsearchMatchPredicateBuilder
extends AbstractElasticsearchSearchPredicateBuilder
implements MatchPredicateBuilder<ElasticsearchSearchPredicateBuilder> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final JsonAccessor<JsonElement> QUERY = JsonAccessor.root().property("query");
    private static final JsonObjectAccessor MATCH = JsonAccessor.root().property("match").asObject();
    private final ElasticsearchSearchContext searchContext;
    private final String absoluteFieldPath;
    private final ElasticsearchFieldConverter converter;

    public ElasticsearchMatchPredicateBuilder(ElasticsearchSearchContext searchContext, String absoluteFieldPath, ElasticsearchFieldConverter converter) {
        this.searchContext = searchContext;
        this.absoluteFieldPath = absoluteFieldPath;
        this.converter = converter;
    }

    public void value(Object value) {
        JsonElement element;
        try {
            element = this.converter.convertDslToIndex(value, this.searchContext.getToIndexFieldValueConvertContext());
        }
        catch (RuntimeException e) {
            throw log.cannotConvertDslParameter(e.getMessage(), e, EventContexts.fromIndexFieldAbsolutePath((String)this.absoluteFieldPath));
        }
        QUERY.set(this.getInnerObject(), element);
    }

    @Override
    protected JsonObject doBuild() {
        JsonObject outerObject = this.getOuterObject();
        JsonObject middleObject = new JsonObject();
        middleObject.add(this.absoluteFieldPath, (JsonElement)this.getInnerObject());
        MATCH.set(outerObject, middleObject);
        return outerObject;
    }
}

