/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.predicate.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.invoke.MethodHandles;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonObjectAccessor;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchContext;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.AbstractElasticsearchSearchPredicateBuilder;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicateBuilder;
import org.hibernate.search.backend.elasticsearch.types.converter.impl.ElasticsearchFieldConverter;
import org.hibernate.search.engine.logging.spi.EventContexts;
import org.hibernate.search.engine.search.predicate.spi.RangePredicateBuilder;
import org.hibernate.search.util.impl.common.LoggerFactory;

public class ElasticsearchRangePredicateBuilder
extends AbstractElasticsearchSearchPredicateBuilder
implements RangePredicateBuilder<ElasticsearchSearchPredicateBuilder> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final JsonObjectAccessor RANGE = JsonAccessor.root().property("range").asObject();
    private static final JsonAccessor<JsonElement> GT = JsonAccessor.root().property("gt");
    private static final JsonAccessor<JsonElement> GTE = JsonAccessor.root().property("gte");
    private static final JsonAccessor<JsonElement> LT = JsonAccessor.root().property("lt");
    private static final JsonAccessor<JsonElement> LTE = JsonAccessor.root().property("lte");
    private final ElasticsearchSearchContext searchContext;
    private final String absoluteFieldPath;
    private final ElasticsearchFieldConverter converter;
    private JsonElement lowerLimit;
    private boolean excludeLowerLimit = false;
    private JsonElement upperLimit;
    private boolean excludeUpperLimit = false;

    public ElasticsearchRangePredicateBuilder(ElasticsearchSearchContext searchContext, String absoluteFieldPath, ElasticsearchFieldConverter converter) {
        this.searchContext = searchContext;
        this.absoluteFieldPath = absoluteFieldPath;
        this.converter = converter;
    }

    public void lowerLimit(Object value) {
        try {
            this.lowerLimit = this.converter.convertDslToIndex(value, this.searchContext.getToIndexFieldValueConvertContext());
        }
        catch (RuntimeException e) {
            throw log.cannotConvertDslParameter(e.getMessage(), e, EventContexts.fromIndexFieldAbsolutePath((String)this.absoluteFieldPath));
        }
    }

    public void excludeLowerLimit() {
        this.excludeLowerLimit = true;
    }

    public void upperLimit(Object value) {
        try {
            this.upperLimit = this.converter.convertDslToIndex(value, this.searchContext.getToIndexFieldValueConvertContext());
        }
        catch (RuntimeException e) {
            throw log.cannotConvertDslParameter(e.getMessage(), e, EventContexts.fromIndexFieldAbsolutePath((String)this.absoluteFieldPath));
        }
    }

    public void excludeUpperLimit() {
        this.excludeUpperLimit = true;
    }

    @Override
    protected JsonObject doBuild() {
        JsonAccessor<JsonElement> accessor;
        JsonObject innerObject = this.getInnerObject();
        if (this.lowerLimit != null) {
            accessor = this.excludeLowerLimit ? GT : GTE;
            accessor.set(innerObject, this.lowerLimit);
        }
        if (this.upperLimit != null) {
            accessor = this.excludeUpperLimit ? LT : LTE;
            accessor.set(innerObject, this.upperLimit);
        }
        JsonObject outerObject = this.getOuterObject();
        JsonObject middleObject = new JsonObject();
        middleObject.add(this.absoluteFieldPath, (JsonElement)innerObject);
        RANGE.set(outerObject, middleObject);
        return outerObject;
    }
}

