/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.projection.impl;

import com.google.gson.JsonObject;
import java.util.function.Function;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchCompositeProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchSearchProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionExecutionContext;
import org.hibernate.search.engine.search.query.spi.LoadingResult;
import org.hibernate.search.engine.search.query.spi.ProjectionHitMapper;

public class ElasticsearchCompositeFunctionProjection<E, P, T>
implements ElasticsearchCompositeProjection<E, T> {
    private final Function<P, T> transformer;
    private final ElasticsearchSearchProjection<E, P> projection;

    public ElasticsearchCompositeFunctionProjection(Function<P, T> transformer, ElasticsearchSearchProjection<E, P> projection) {
        this.transformer = transformer;
        this.projection = projection;
    }

    @Override
    public void contributeRequest(JsonObject requestBody, SearchProjectionExecutionContext searchProjectionExecutionContext) {
        this.projection.contributeRequest(requestBody, searchProjectionExecutionContext);
    }

    @Override
    public E extract(ProjectionHitMapper<?, ?> projectionHitMapper, JsonObject responseBody, JsonObject hit, SearchProjectionExecutionContext searchProjectionExecutionContext) {
        return this.projection.extract(projectionHitMapper, responseBody, hit, searchProjectionExecutionContext);
    }

    @Override
    public T transform(LoadingResult<?> loadingResult, E extractedData) {
        return this.transformer.apply(this.projection.transform(loadingResult, extractedData));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("[").append("projection=").append(this.projection).append("]");
        return sb.toString();
    }
}

