/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.projection.impl;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchCompositeProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchSearchProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionExecutionContext;
import org.hibernate.search.engine.search.query.spi.LoadingResult;
import org.hibernate.search.engine.search.query.spi.ProjectionHitMapper;

public class ElasticsearchCompositeListProjection<T>
implements ElasticsearchCompositeProjection<List<Object>, T> {
    private final Function<List<?>, T> transformer;
    private final List<ElasticsearchSearchProjection<?, ?>> children;

    public ElasticsearchCompositeListProjection(Function<List<?>, T> transformer, List<ElasticsearchSearchProjection<?, ?>> children) {
        this.transformer = transformer;
        this.children = children;
    }

    @Override
    public void contributeRequest(JsonObject requestBody, SearchProjectionExecutionContext searchProjectionExecutionContext) {
        for (ElasticsearchSearchProjection<?, ?> child : this.children) {
            child.contributeRequest(requestBody, searchProjectionExecutionContext);
        }
    }

    @Override
    public List<Object> extract(ProjectionHitMapper<?, ?> projectionHitMapper, JsonObject responseBody, JsonObject hit, SearchProjectionExecutionContext searchProjectionExecutionContext) {
        ArrayList<Object> extractedData = new ArrayList<Object>(this.children.size());
        for (ElasticsearchSearchProjection<?, ?> child : this.children) {
            extractedData.add(child.extract(projectionHitMapper, responseBody, hit, searchProjectionExecutionContext));
        }
        return extractedData;
    }

    @Override
    public T transform(LoadingResult<?> loadingResult, List<Object> extractedData) {
        for (int i = 0; i < extractedData.size(); ++i) {
            extractedData.set(i, ElasticsearchSearchProjection.transformUnsafe(this.children.get(i), loadingResult, extractedData.get(i)));
        }
        return this.transformer.apply(extractedData);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("[").append("children=").append(this.children).append("]");
        return sb.toString();
    }
}

