/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.projection.impl;

import com.google.gson.JsonObject;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchCompositeProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchSearchProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionExecutionContext;
import org.hibernate.search.engine.search.query.spi.LoadingResult;
import org.hibernate.search.engine.search.query.spi.ProjectionHitMapper;
import org.hibernate.search.util.function.TriFunction;

public class ElasticsearchCompositeTriFunctionProjection<P1, P2, P3, T>
implements ElasticsearchCompositeProjection<Object[], T> {
    private final TriFunction<P1, P2, P3, T> transformer;
    private final ElasticsearchSearchProjection<?, P1> projection1;
    private final ElasticsearchSearchProjection<?, P2> projection2;
    private final ElasticsearchSearchProjection<?, P3> projection3;

    public ElasticsearchCompositeTriFunctionProjection(TriFunction<P1, P2, P3, T> transformer, ElasticsearchSearchProjection<?, P1> projection1, ElasticsearchSearchProjection<?, P2> projection2, ElasticsearchSearchProjection<?, P3> projection3) {
        this.transformer = transformer;
        this.projection1 = projection1;
        this.projection2 = projection2;
        this.projection3 = projection3;
    }

    @Override
    public void contributeRequest(JsonObject requestBody, SearchProjectionExecutionContext searchProjectionExecutionContext) {
        this.projection1.contributeRequest(requestBody, searchProjectionExecutionContext);
        this.projection2.contributeRequest(requestBody, searchProjectionExecutionContext);
        this.projection3.contributeRequest(requestBody, searchProjectionExecutionContext);
    }

    @Override
    public Object[] extract(ProjectionHitMapper<?, ?> projectionHitMapper, JsonObject responseBody, JsonObject hit, SearchProjectionExecutionContext searchProjectionExecutionContext) {
        return new Object[]{this.projection1.extract(projectionHitMapper, responseBody, hit, searchProjectionExecutionContext), this.projection2.extract(projectionHitMapper, responseBody, hit, searchProjectionExecutionContext), this.projection3.extract(projectionHitMapper, responseBody, hit, searchProjectionExecutionContext)};
    }

    @Override
    public T transform(LoadingResult<?> loadingResult, Object[] extractedData) {
        return (T)this.transformer.apply(ElasticsearchSearchProjection.transformUnsafe(this.projection1, loadingResult, extractedData[0]), ElasticsearchSearchProjection.transformUnsafe(this.projection2, loadingResult, extractedData[1]), ElasticsearchSearchProjection.transformUnsafe(this.projection3, loadingResult, extractedData[2]));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("[").append("projection1=").append(this.projection1).append(", projection2=").append(this.projection2).append(", projection3=").append(this.projection3).append("]");
        return sb.toString();
    }
}

