/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.projection.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonArrayAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonObjectAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.UnknownTypeJsonAccessor;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchSearchProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionExecutionContext;
import org.hibernate.search.backend.elasticsearch.types.converter.impl.ElasticsearchFieldConverter;
import org.hibernate.search.engine.backend.document.converter.runtime.FromIndexFieldValueConvertContext;
import org.hibernate.search.engine.search.query.spi.LoadingResult;
import org.hibernate.search.engine.search.query.spi.ProjectionHitMapper;

class ElasticsearchFieldProjection<T>
implements ElasticsearchSearchProjection<T, T> {
    private static final JsonArrayAccessor REQUEST_SOURCE_ACCESSOR = JsonAccessor.root().property("_source").asArray();
    private static final JsonObjectAccessor HIT_SOURCE_ACCESSOR = JsonAccessor.root().property("_source").asObject();
    private final String absoluteFieldPath;
    private final UnknownTypeJsonAccessor hitFieldValueAccessor;
    private final ElasticsearchFieldConverter converter;

    ElasticsearchFieldProjection(String absoluteFieldPath, ElasticsearchFieldConverter converter) {
        this.absoluteFieldPath = absoluteFieldPath;
        this.hitFieldValueAccessor = HIT_SOURCE_ACCESSOR.path(absoluteFieldPath);
        this.converter = converter;
    }

    @Override
    public void contributeRequest(JsonObject requestBody, SearchProjectionExecutionContext searchProjectionExecutionContext) {
        JsonPrimitive fieldPathJson;
        JsonArray source = REQUEST_SOURCE_ACCESSOR.get(requestBody).orElseGet(() -> {
            JsonArray newSource = new JsonArray();
            REQUEST_SOURCE_ACCESSOR.set(requestBody, newSource);
            return newSource;
        });
        if (!source.contains((JsonElement)(fieldPathJson = new JsonPrimitive(this.absoluteFieldPath)))) {
            source.add((JsonElement)fieldPathJson);
        }
    }

    @Override
    public T extract(ProjectionHitMapper<?, ?> projectionHitMapper, JsonObject responseBody, JsonObject hit, SearchProjectionExecutionContext searchProjectionExecutionContext) {
        JsonElement fieldValue = this.hitFieldValueAccessor.get(hit).orElse(null);
        FromIndexFieldValueConvertContext context = searchProjectionExecutionContext.getFromIndexFieldValueConvertContext();
        return (T)this.converter.convertIndexToProjection(fieldValue, context);
    }

    @Override
    public T transform(LoadingResult<?> loadingResult, T extractedData) {
        return extractedData;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("[").append("absoluteFieldPath=").append(this.absoluteFieldPath).append("]");
        return sb.toString();
    }
}

