/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.query.impl;

import com.google.gson.JsonObject;
import java.util.Set;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.util.impl.URLEncodedString;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchSearchResultExtractor;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWork;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWorkFactory;
import org.hibernate.search.engine.search.SearchQuery;
import org.hibernate.search.engine.search.SearchResult;

public class ElasticsearchSearchQuery<T>
implements SearchQuery<T> {
    private final ElasticsearchWorkFactory workFactory;
    private final ElasticsearchWorkOrchestrator queryOrchestrator;
    private final Set<URLEncodedString> indexNames;
    private final Set<String> routingKeys;
    private final JsonObject payload;
    private final ElasticsearchSearchResultExtractor<T> searchResultExtractor;
    private Long firstResultIndex;
    private Long maxResultsCount;

    public ElasticsearchSearchQuery(ElasticsearchWorkFactory workFactory, ElasticsearchWorkOrchestrator queryOrchestrator, Set<URLEncodedString> indexNames, Set<String> routingKeys, JsonObject payload, ElasticsearchSearchResultExtractor<T> searchResultExtractor) {
        this.workFactory = workFactory;
        this.queryOrchestrator = queryOrchestrator;
        this.indexNames = indexNames;
        this.routingKeys = routingKeys;
        this.payload = payload;
        this.searchResultExtractor = searchResultExtractor;
    }

    public void setFirstResult(Long firstResultIndex) {
        this.firstResultIndex = firstResultIndex;
    }

    public void setMaxResults(Long maxResultsCount) {
        this.maxResultsCount = maxResultsCount;
    }

    public String getQueryString() {
        return this.payload.toString();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getQueryString() + "]";
    }

    public SearchResult<T> execute() {
        ElasticsearchWork<SearchResult<T>> work = this.workFactory.search(this.indexNames, this.routingKeys, this.payload, this.searchResultExtractor, this.firstResultIndex, this.maxResultsCount);
        return this.queryOrchestrator.submit(work).join();
    }
}

