/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.query.impl;

import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchContext;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchQueryElementCollector;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchTargetModel;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicateBuilderFactoryImpl;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchSearchProjectionBuilderFactory;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchSearchQueryBuilderFactory;
import org.hibernate.search.backend.elasticsearch.search.query.impl.SearchBackendContext;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.ElasticsearchSearchSortBuilderFactoryImpl;
import org.hibernate.search.engine.mapper.mapping.context.spi.MappingContextImplementor;
import org.hibernate.search.engine.search.dsl.spi.SearchTargetContext;

public class ElasticsearchSearchTargetContext
implements SearchTargetContext<ElasticsearchSearchQueryElementCollector> {
    private final ElasticsearchSearchTargetModel searchTargetModel;
    private final ElasticsearchSearchPredicateBuilderFactoryImpl searchPredicateFactory;
    private final ElasticsearchSearchSortBuilderFactoryImpl searchSortFactory;
    private final ElasticsearchSearchQueryBuilderFactory searchQueryFactory;
    private final ElasticsearchSearchProjectionBuilderFactory searchProjectionFactory;

    public ElasticsearchSearchTargetContext(MappingContextImplementor mappingContext, SearchBackendContext searchBackendContext, ElasticsearchSearchTargetModel searchTargetModel) {
        ElasticsearchSearchContext searchContext = new ElasticsearchSearchContext(mappingContext);
        this.searchTargetModel = searchTargetModel;
        this.searchPredicateFactory = new ElasticsearchSearchPredicateBuilderFactoryImpl(searchContext, searchTargetModel);
        this.searchSortFactory = new ElasticsearchSearchSortBuilderFactoryImpl(searchContext, searchTargetModel);
        this.searchProjectionFactory = new ElasticsearchSearchProjectionBuilderFactory(searchBackendContext.getSearchProjectionBackendContext(), searchTargetModel);
        this.searchQueryFactory = new ElasticsearchSearchQueryBuilderFactory(searchBackendContext, searchTargetModel, this.searchProjectionFactory);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "indexNames=" + this.searchTargetModel.getHibernateSearchIndexNames() + "]";
    }

    public ElasticsearchSearchPredicateBuilderFactoryImpl getSearchPredicateBuilderFactory() {
        return this.searchPredicateFactory;
    }

    public ElasticsearchSearchSortBuilderFactoryImpl getSearchSortBuilderFactory() {
        return this.searchSortFactory;
    }

    public ElasticsearchSearchQueryBuilderFactory getSearchQueryBuilderFactory() {
        return this.searchQueryFactory;
    }

    public ElasticsearchSearchProjectionBuilderFactory getSearchProjectionFactory() {
        return this.searchProjectionFactory;
    }
}

