/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.query.impl;

import java.util.Set;
import java.util.function.Function;
import org.hibernate.search.backend.elasticsearch.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.DocumentReferenceExtractorHelper;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchSearchProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionBackendContext;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchSearchQueryBuilder;
import org.hibernate.search.backend.elasticsearch.util.impl.URLEncodedString;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWorkFactory;
import org.hibernate.search.engine.mapper.session.context.spi.SessionContextImplementor;
import org.hibernate.search.engine.search.query.spi.ProjectionHitMapper;
import org.hibernate.search.util.EventContext;

public class SearchBackendContext {
    private final EventContext eventContext;
    private final ElasticsearchWorkFactory workFactory;
    private final MultiTenancyStrategy multiTenancyStrategy;
    private final ElasticsearchWorkOrchestrator orchestrator;
    private final SearchProjectionBackendContext searchProjectionBackendContext;
    private final DocumentReferenceExtractorHelper documentReferenceExtractorHelper;

    public SearchBackendContext(EventContext eventContext, ElasticsearchWorkFactory workFactory, Function<String, String> indexNameConverter, MultiTenancyStrategy multiTenancyStrategy, ElasticsearchWorkOrchestrator orchestrator) {
        this.eventContext = eventContext;
        this.workFactory = workFactory;
        this.multiTenancyStrategy = multiTenancyStrategy;
        this.orchestrator = orchestrator;
        this.documentReferenceExtractorHelper = new DocumentReferenceExtractorHelper(indexNameConverter, multiTenancyStrategy);
        this.searchProjectionBackendContext = new SearchProjectionBackendContext(this.documentReferenceExtractorHelper);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.eventContext + "]";
    }

    public EventContext getEventContext() {
        return this.eventContext;
    }

    DocumentReferenceExtractorHelper getDocumentReferenceExtractorHelper() {
        return this.documentReferenceExtractorHelper;
    }

    SearchProjectionBackendContext getSearchProjectionBackendContext() {
        return this.searchProjectionBackendContext;
    }

    <T> ElasticsearchSearchQueryBuilder<T> createSearchQueryBuilder(Set<URLEncodedString> indexNames, SessionContextImplementor sessionContext, ProjectionHitMapper<?, ?> projectionHitMapper, ElasticsearchSearchProjection<?, T> rootProjection) {
        this.multiTenancyStrategy.checkTenantId(sessionContext.getTenantIdentifier(), this.eventContext);
        return new ElasticsearchSearchQueryBuilder<T>(this.workFactory, this.orchestrator, this.multiTenancyStrategy, indexNames, sessionContext, projectionHitMapper, rootProjection);
    }
}

