/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.sort.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.ElasticsearchSearchSortBuilder;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.ElasticsearchSearchSortCollector;
import org.hibernate.search.engine.search.dsl.sort.SortOrder;
import org.hibernate.search.engine.search.sort.spi.SearchSortBuilder;
import org.hibernate.search.util.AssertionFailure;

abstract class AbstractElasticsearchSearchSortBuilder
implements SearchSortBuilder<ElasticsearchSearchSortBuilder>,
ElasticsearchSearchSortBuilder {
    private static final JsonAccessor<JsonElement> ORDER = JsonAccessor.root().property("order");
    private static final JsonPrimitive ASC_KEYWORD_JSON = new JsonPrimitive("asc");
    private static final JsonPrimitive DESC_KEYWORD_JSON = new JsonPrimitive("desc");
    private final JsonObject innerObject = new JsonObject();
    private boolean built;

    AbstractElasticsearchSearchSortBuilder() {
    }

    public ElasticsearchSearchSortBuilder toImplementation() {
        return this;
    }

    public void order(SortOrder order) {
        switch (order) {
            case ASC: {
                ORDER.set(this.getInnerObject(), (JsonElement)ASC_KEYWORD_JSON);
                break;
            }
            case DESC: {
                ORDER.set(this.getInnerObject(), (JsonElement)DESC_KEYWORD_JSON);
            }
        }
    }

    @Override
    public final void buildAndAddTo(ElasticsearchSearchSortCollector collector) {
        if (this.built) {
            throw new AssertionFailure("A sort builder was called twice. There is a bug in Hibernate Search, please report it.");
        }
        this.built = true;
        this.doBuildAndAddTo(collector);
    }

    protected final JsonObject getInnerObject() {
        return this.innerObject;
    }

    protected abstract void doBuildAndAddTo(ElasticsearchSearchSortCollector var1);
}

