/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.sort.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonObjectAccessor;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.AbstractElasticsearchSearchSortBuilder;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.ElasticsearchSearchSortBuilder;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.ElasticsearchSearchSortCollector;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchGeoPointFieldCodec;
import org.hibernate.search.engine.search.sort.spi.DistanceSortBuilder;
import org.hibernate.search.engine.spatial.GeoPoint;

public class ElasticsearchDistanceSortBuilder
extends AbstractElasticsearchSearchSortBuilder
implements DistanceSortBuilder<ElasticsearchSearchSortBuilder> {
    private static final JsonObjectAccessor GEO_DISTANCE = JsonAccessor.root().property("_geo_distance").asObject();
    private final String absoluteFieldPath;
    private final GeoPoint location;

    public ElasticsearchDistanceSortBuilder(String absoluteFieldPath, GeoPoint location) {
        this.absoluteFieldPath = absoluteFieldPath;
        this.location = location;
    }

    @Override
    protected void doBuildAndAddTo(ElasticsearchSearchSortCollector collector) {
        this.getInnerObject().add(this.absoluteFieldPath, ElasticsearchGeoPointFieldCodec.INSTANCE.encode(this.location));
        JsonObject outerObject = new JsonObject();
        GEO_DISTANCE.add(outerObject, this.getInnerObject());
        collector.collectDistanceSort((JsonElement)outerObject, this.absoluteFieldPath, this.location);
    }
}

