/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.sort.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.lang.invoke.MethodHandles;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchContext;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.AbstractElasticsearchSearchSortBuilder;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.ElasticsearchSearchSortBuilder;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.ElasticsearchSearchSortCollector;
import org.hibernate.search.backend.elasticsearch.types.converter.impl.ElasticsearchFieldConverter;
import org.hibernate.search.engine.logging.spi.EventContexts;
import org.hibernate.search.engine.search.sort.spi.FieldSortBuilder;
import org.hibernate.search.util.impl.common.LoggerFactory;

public class ElasticsearchFieldSortBuilder
extends AbstractElasticsearchSearchSortBuilder
implements FieldSortBuilder<ElasticsearchSearchSortBuilder> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final JsonAccessor<JsonElement> MISSING = JsonAccessor.root().property("missing");
    private static final JsonPrimitive MISSING_FIRST_KEYWORD_JSON = new JsonPrimitive("_first");
    private static final JsonPrimitive MISSING_LAST_KEYWORD_JSON = new JsonPrimitive("_last");
    private final ElasticsearchSearchContext searchContext;
    private final String absoluteFieldPath;
    private final ElasticsearchFieldConverter converter;

    public ElasticsearchFieldSortBuilder(ElasticsearchSearchContext searchContext, String absoluteFieldPath, ElasticsearchFieldConverter converter) {
        this.searchContext = searchContext;
        this.absoluteFieldPath = absoluteFieldPath;
        this.converter = converter;
    }

    public void missingFirst() {
        MISSING.set(this.getInnerObject(), (JsonElement)MISSING_FIRST_KEYWORD_JSON);
    }

    public void missingLast() {
        MISSING.set(this.getInnerObject(), (JsonElement)MISSING_LAST_KEYWORD_JSON);
    }

    public void missingAs(Object value) {
        JsonElement element;
        try {
            element = this.converter.convertDslToIndex(value, this.searchContext.getToIndexFieldValueConvertContext());
        }
        catch (RuntimeException e) {
            throw log.cannotConvertDslParameter(e.getMessage(), e, EventContexts.fromIndexFieldAbsolutePath((String)this.absoluteFieldPath));
        }
        MISSING.set(this.getInnerObject(), element);
    }

    @Override
    public void doBuildAndAddTo(ElasticsearchSearchSortCollector collector) {
        JsonObject innerObject = this.getInnerObject();
        if (innerObject.size() == 0) {
            collector.collectSort((JsonElement)new JsonPrimitive(this.absoluteFieldPath));
        } else {
            JsonObject outerObject = new JsonObject();
            outerObject.add(this.absoluteFieldPath, (JsonElement)innerObject);
            collector.collectSort((JsonElement)outerObject);
        }
    }
}

