/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.sort.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaFieldNode;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchContext;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchQueryElementCollector;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchTargetModel;
import org.hibernate.search.backend.elasticsearch.search.impl.IndexSchemaFieldNodeComponentRetrievalStrategy;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.ElasticsearchIndexOrderSortBuilder;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.ElasticsearchScoreSortBuilder;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.ElasticsearchSearchSort;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.ElasticsearchSearchSortBuilder;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.ElasticsearchSearchSortBuilderFactory;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.ElasticsearchSearchSortCollector;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.ElasticsearchUserProvidedJsonSortBuilder;
import org.hibernate.search.backend.elasticsearch.types.sort.impl.ElasticsearchFieldSortBuilderFactory;
import org.hibernate.search.engine.search.SearchSort;
import org.hibernate.search.engine.search.sort.spi.DistanceSortBuilder;
import org.hibernate.search.engine.search.sort.spi.FieldSortBuilder;
import org.hibernate.search.engine.search.sort.spi.ScoreSortBuilder;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.hibernate.search.util.EventContext;
import org.hibernate.search.util.SearchException;
import org.hibernate.search.util.impl.common.LoggerFactory;

public class ElasticsearchSearchSortBuilderFactoryImpl
implements ElasticsearchSearchSortBuilderFactory {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final Gson GSON = new GsonBuilder().create();
    private static final SortBuilderFactoryRetrievalStrategy SORT_BUILDER_FACTORY_RETRIEVAL_STRATEGY = new SortBuilderFactoryRetrievalStrategy();
    private final ElasticsearchSearchContext searchContext;
    private final ElasticsearchSearchTargetModel searchTargetModel;

    public ElasticsearchSearchSortBuilderFactoryImpl(ElasticsearchSearchContext searchContext, ElasticsearchSearchTargetModel searchTargetModel) {
        this.searchContext = searchContext;
        this.searchTargetModel = searchTargetModel;
    }

    public SearchSort toSearchSort(List<ElasticsearchSearchSortBuilder> builders) {
        ElasticsearchSearchQueryElementCollector collector = new ElasticsearchSearchQueryElementCollector();
        for (ElasticsearchSearchSortBuilder builder : builders) {
            builder.buildAndAddTo(collector);
        }
        return new ElasticsearchSearchSort(collector.toJsonSort());
    }

    public void toImplementation(SearchSort sort, Consumer<? super ElasticsearchSearchSortBuilder> implementationConsumer) {
        if (!(sort instanceof ElasticsearchSearchSort)) {
            throw log.cannotMixElasticsearchSearchSortWithOtherSorts(sort);
        }
        implementationConsumer.accept((ElasticsearchSearchSort)sort);
    }

    public void contribute(ElasticsearchSearchSortCollector collector, List<ElasticsearchSearchSortBuilder> builders) {
        for (ElasticsearchSearchSortBuilder builder : builders) {
            builder.buildAndAddTo(collector);
        }
    }

    public ScoreSortBuilder<ElasticsearchSearchSortBuilder> score() {
        return new ElasticsearchScoreSortBuilder();
    }

    public FieldSortBuilder<ElasticsearchSearchSortBuilder> field(String absoluteFieldPath) {
        return this.searchTargetModel.getSchemaNodeComponent(absoluteFieldPath, SORT_BUILDER_FACTORY_RETRIEVAL_STRATEGY).createFieldSortBuilder(this.searchContext, absoluteFieldPath);
    }

    public DistanceSortBuilder<ElasticsearchSearchSortBuilder> distance(String absoluteFieldPath, GeoPoint location) {
        return this.searchTargetModel.getSchemaNodeComponent(absoluteFieldPath, SORT_BUILDER_FACTORY_RETRIEVAL_STRATEGY).createDistanceSortBuilder(absoluteFieldPath, location);
    }

    public ElasticsearchSearchSortBuilder indexOrder() {
        return ElasticsearchIndexOrderSortBuilder.INSTANCE;
    }

    @Override
    public ElasticsearchSearchSortBuilder fromJsonString(String jsonString) {
        return new ElasticsearchUserProvidedJsonSortBuilder((JsonObject)GSON.fromJson(jsonString, JsonObject.class));
    }

    private static class SortBuilderFactoryRetrievalStrategy
    implements IndexSchemaFieldNodeComponentRetrievalStrategy<ElasticsearchFieldSortBuilderFactory> {
        private SortBuilderFactoryRetrievalStrategy() {
        }

        @Override
        public ElasticsearchFieldSortBuilderFactory extractComponent(ElasticsearchIndexSchemaFieldNode<?> schemaNode) {
            return schemaNode.getSortBuilderFactory();
        }

        @Override
        public boolean areCompatible(ElasticsearchFieldSortBuilderFactory component1, ElasticsearchFieldSortBuilderFactory component2) {
            return component1.isDslCompatibleWith(component2);
        }

        @Override
        public SearchException createCompatibilityException(String absoluteFieldPath, ElasticsearchFieldSortBuilderFactory component1, ElasticsearchFieldSortBuilderFactory component2, EventContext context) {
            return log.conflictingFieldTypesForSort(absoluteFieldPath, component1, component2, context);
        }
    }
}

