/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.codec.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonPrimitive;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonElementTypes;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchFieldCodec;

public class ElasticsearchLocalDateFieldCodec
implements ElasticsearchFieldCodec<LocalDate> {
    private final DateTimeFormatter formatter;

    public ElasticsearchLocalDateFieldCodec(DateTimeFormatter delegate) {
        this.formatter = delegate;
    }

    @Override
    public JsonElement encode(LocalDate value) {
        if (value == null) {
            return JsonNull.INSTANCE;
        }
        return new JsonPrimitive(this.formatter.format(value));
    }

    @Override
    public LocalDate decode(JsonElement element) {
        if (element == null || element.isJsonNull()) {
            return null;
        }
        String stringValue = JsonElementTypes.STRING.fromElement(element);
        return LocalDate.parse(stringValue, this.formatter);
    }

    @Override
    public boolean isCompatibleWith(ElasticsearchFieldCodec<?> obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ElasticsearchLocalDateFieldCodec other = (ElasticsearchLocalDateFieldCodec)obj;
        return this.formatter.equals(other.formatter);
    }
}

