/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.converter.impl;

import com.google.gson.JsonElement;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchFieldCodec;
import org.hibernate.search.backend.elasticsearch.types.converter.impl.ElasticsearchFieldConverter;
import org.hibernate.search.engine.backend.document.converter.runtime.FromIndexFieldValueConvertContext;
import org.hibernate.search.engine.backend.document.converter.runtime.ToIndexFieldValueConvertContext;
import org.hibernate.search.engine.backend.document.spi.UserIndexFieldConverter;

public final class ElasticsearchStandardFieldConverter<F>
implements ElasticsearchFieldConverter {
    private final UserIndexFieldConverter<F> userConverter;
    private final ElasticsearchFieldCodec<F> codec;

    public ElasticsearchStandardFieldConverter(UserIndexFieldConverter<F> userConverter, ElasticsearchFieldCodec<F> codec) {
        this.userConverter = userConverter;
        this.codec = codec;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.userConverter + "]";
    }

    @Override
    public JsonElement convertDslToIndex(Object value, ToIndexFieldValueConvertContext context) {
        Object rawValue = this.userConverter.convertDslToIndex(value, context);
        return this.codec.encode(rawValue);
    }

    @Override
    public Object convertIndexToProjection(JsonElement element, FromIndexFieldValueConvertContext context) {
        F rawValue = this.codec.decode(element);
        return this.userConverter.convertIndexToProjection(rawValue, context);
    }

    @Override
    public boolean isConvertDslToIndexCompatibleWith(ElasticsearchFieldConverter other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        ElasticsearchStandardFieldConverter castedOther = (ElasticsearchStandardFieldConverter)other;
        return this.userConverter.isConvertDslToIndexCompatibleWith(castedOther.userConverter) && this.codec.isCompatibleWith(castedOther.codec);
    }

    @Override
    public boolean isConvertIndexToProjectionCompatibleWith(ElasticsearchFieldConverter other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        ElasticsearchStandardFieldConverter castedOther = (ElasticsearchStandardFieldConverter)other;
        return this.userConverter.isConvertIndexToProjectionCompatibleWith(castedOther.userConverter) && this.codec.isCompatibleWith(castedOther.codec);
    }

    @Override
    public boolean isProjectionCompatibleWith(Class<?> projectionType) {
        return this.userConverter.isProjectionCompatibleWith(projectionType);
    }
}

