/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.dsl.impl;

import org.hibernate.search.backend.elasticsearch.document.impl.ElasticsearchIndexFieldAccessor;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaFieldNode;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaNodeCollector;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaObjectNode;
import org.hibernate.search.backend.elasticsearch.document.model.impl.esnative.DataType;
import org.hibernate.search.backend.elasticsearch.document.model.impl.esnative.PropertyMapping;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.UnknownTypeJsonAccessor;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchBooleanFieldCodec;
import org.hibernate.search.backend.elasticsearch.types.converter.impl.ElasticsearchStandardFieldConverter;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.AbstractElasticsearchScalarFieldTypedContext;
import org.hibernate.search.backend.elasticsearch.types.predicate.impl.ElasticsearchStandardFieldPredicateBuilderFactory;
import org.hibernate.search.backend.elasticsearch.types.projection.impl.ElasticsearchStandardFieldProjectionBuilderFactory;
import org.hibernate.search.backend.elasticsearch.types.sort.impl.ElasticsearchStandardFieldSortBuilderFactory;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexSchemaContext;
import org.hibernate.search.engine.backend.document.spi.IndexSchemaFieldDefinitionHelper;

public class ElasticsearchBooleanIndexSchemaFieldContext
extends AbstractElasticsearchScalarFieldTypedContext<ElasticsearchBooleanIndexSchemaFieldContext, Boolean> {
    private final String relativeFieldName;

    public ElasticsearchBooleanIndexSchemaFieldContext(IndexSchemaContext schemaContext, String relativeFieldName) {
        super(schemaContext, Boolean.class, DataType.BOOLEAN);
        this.relativeFieldName = relativeFieldName;
    }

    @Override
    protected PropertyMapping contribute(IndexSchemaFieldDefinitionHelper<Boolean> helper, ElasticsearchIndexSchemaNodeCollector collector, ElasticsearchIndexSchemaObjectNode parentNode) {
        PropertyMapping mapping = super.contribute(helper, collector, parentNode);
        ElasticsearchStandardFieldConverter<Boolean> converter = new ElasticsearchStandardFieldConverter<Boolean>(helper.createUserIndexFieldConverter(), ElasticsearchBooleanFieldCodec.INSTANCE);
        ElasticsearchIndexSchemaFieldNode<Boolean> node = new ElasticsearchIndexSchemaFieldNode<Boolean>(parentNode, converter, ElasticsearchBooleanFieldCodec.INSTANCE, new ElasticsearchStandardFieldPredicateBuilderFactory(converter), new ElasticsearchStandardFieldSortBuilderFactory(this.resolvedSortable, converter), new ElasticsearchStandardFieldProjectionBuilderFactory(this.resolvedProjectable, converter));
        UnknownTypeJsonAccessor jsonAccessor = JsonAccessor.root().property(this.relativeFieldName);
        helper.initialize(new ElasticsearchIndexFieldAccessor<Boolean>(jsonAccessor, node));
        String absoluteFieldPath = parentNode.getAbsolutePath(this.relativeFieldName);
        collector.collect(absoluteFieldPath, node);
        return mapping;
    }

    @Override
    protected ElasticsearchBooleanIndexSchemaFieldContext thisAsS() {
        return this;
    }
}

