/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.dsl.impl;

import org.hibernate.search.backend.elasticsearch.document.impl.ElasticsearchIndexFieldAccessor;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaFieldNode;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaNodeCollector;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaObjectNode;
import org.hibernate.search.backend.elasticsearch.document.model.impl.esnative.DataType;
import org.hibernate.search.backend.elasticsearch.document.model.impl.esnative.PropertyMapping;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.UnknownTypeJsonAccessor;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchGeoPointFieldCodec;
import org.hibernate.search.backend.elasticsearch.types.converter.impl.ElasticsearchStandardFieldConverter;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.AbstractElasticsearchScalarFieldTypedContext;
import org.hibernate.search.backend.elasticsearch.types.predicate.impl.ElasticsearchGeoPointFieldPredicateBuilderFactory;
import org.hibernate.search.backend.elasticsearch.types.projection.impl.ElasticsearchGeoPointFieldProjectionBuilderFactory;
import org.hibernate.search.backend.elasticsearch.types.sort.impl.ElasticsearchGeoPointFieldSortBuilderFactory;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexSchemaContext;
import org.hibernate.search.engine.backend.document.spi.IndexSchemaFieldDefinitionHelper;
import org.hibernate.search.engine.spatial.GeoPoint;

public class ElasticsearchGeoPointIndexSchemaFieldContext
extends AbstractElasticsearchScalarFieldTypedContext<ElasticsearchGeoPointIndexSchemaFieldContext, GeoPoint> {
    private final String relativeFieldName;

    public ElasticsearchGeoPointIndexSchemaFieldContext(IndexSchemaContext schemaContext, String relativeFieldName) {
        super(schemaContext, GeoPoint.class, DataType.GEO_POINT);
        this.relativeFieldName = relativeFieldName;
    }

    @Override
    protected PropertyMapping contribute(IndexSchemaFieldDefinitionHelper<GeoPoint> helper, ElasticsearchIndexSchemaNodeCollector collector, ElasticsearchIndexSchemaObjectNode parentNode) {
        PropertyMapping mapping = super.contribute(helper, collector, parentNode);
        ElasticsearchStandardFieldConverter<GeoPoint> converter = new ElasticsearchStandardFieldConverter<GeoPoint>(helper.createUserIndexFieldConverter(), ElasticsearchGeoPointFieldCodec.INSTANCE);
        ElasticsearchIndexSchemaFieldNode<GeoPoint> node = new ElasticsearchIndexSchemaFieldNode<GeoPoint>(parentNode, converter, ElasticsearchGeoPointFieldCodec.INSTANCE, ElasticsearchGeoPointFieldPredicateBuilderFactory.INSTANCE, new ElasticsearchGeoPointFieldSortBuilderFactory(this.resolvedSortable), new ElasticsearchGeoPointFieldProjectionBuilderFactory(this.resolvedProjectable, converter));
        UnknownTypeJsonAccessor jsonAccessor = JsonAccessor.root().property(this.relativeFieldName);
        helper.initialize(new ElasticsearchIndexFieldAccessor<GeoPoint>(jsonAccessor, node));
        String absoluteFieldPath = parentNode.getAbsolutePath(this.relativeFieldName);
        collector.collect(absoluteFieldPath, node);
        return mapping;
    }

    @Override
    protected ElasticsearchGeoPointIndexSchemaFieldContext thisAsS() {
        return this;
    }
}

