/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.dsl.impl;

import java.time.Instant;
import java.util.Arrays;
import org.hibernate.search.backend.elasticsearch.document.impl.ElasticsearchIndexFieldAccessor;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaFieldNode;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaNodeCollector;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaObjectNode;
import org.hibernate.search.backend.elasticsearch.document.model.impl.esnative.DataType;
import org.hibernate.search.backend.elasticsearch.document.model.impl.esnative.PropertyMapping;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.UnknownTypeJsonAccessor;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchInstantFieldCodec;
import org.hibernate.search.backend.elasticsearch.types.converter.impl.ElasticsearchStandardFieldConverter;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.AbstractElasticsearchScalarFieldTypedContext;
import org.hibernate.search.backend.elasticsearch.types.predicate.impl.ElasticsearchStandardFieldPredicateBuilderFactory;
import org.hibernate.search.backend.elasticsearch.types.projection.impl.ElasticsearchStandardFieldProjectionBuilderFactory;
import org.hibernate.search.backend.elasticsearch.types.sort.impl.ElasticsearchStandardFieldSortBuilderFactory;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexSchemaContext;
import org.hibernate.search.engine.backend.document.spi.IndexSchemaFieldDefinitionHelper;

public class ElasticsearchInstantIndexSchemaFieldContext
extends AbstractElasticsearchScalarFieldTypedContext<ElasticsearchInstantIndexSchemaFieldContext, Instant> {
    private final String relativeFieldName;

    public ElasticsearchInstantIndexSchemaFieldContext(IndexSchemaContext schemaContext, String relativeFieldName) {
        super(schemaContext, Instant.class, DataType.DATE);
        this.relativeFieldName = relativeFieldName;
    }

    @Override
    protected PropertyMapping contribute(IndexSchemaFieldDefinitionHelper<Instant> helper, ElasticsearchIndexSchemaNodeCollector collector, ElasticsearchIndexSchemaObjectNode parentNode) {
        PropertyMapping mapping = super.contribute(helper, collector, parentNode);
        ElasticsearchStandardFieldConverter<Instant> converter = new ElasticsearchStandardFieldConverter<Instant>(helper.createUserIndexFieldConverter(), ElasticsearchInstantFieldCodec.INSTANCE);
        ElasticsearchIndexSchemaFieldNode<Instant> node = new ElasticsearchIndexSchemaFieldNode<Instant>(parentNode, converter, ElasticsearchInstantFieldCodec.INSTANCE, new ElasticsearchStandardFieldPredicateBuilderFactory(converter), new ElasticsearchStandardFieldSortBuilderFactory(this.resolvedSortable, converter), new ElasticsearchStandardFieldProjectionBuilderFactory(this.resolvedProjectable, converter));
        UnknownTypeJsonAccessor jsonAccessor = JsonAccessor.root().property(this.relativeFieldName);
        helper.initialize(new ElasticsearchIndexFieldAccessor<Instant>(jsonAccessor, node));
        mapping.setFormat(Arrays.asList("epoch_millis"));
        String absoluteFieldPath = parentNode.getAbsolutePath(this.relativeFieldName);
        collector.collect(absoluteFieldPath, node);
        return mapping;
    }

    @Override
    protected ElasticsearchInstantIndexSchemaFieldContext thisAsS() {
        return this;
    }
}

