/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.dsl.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import org.hibernate.search.backend.elasticsearch.document.impl.ElasticsearchIndexFieldAccessor;
import org.hibernate.search.backend.elasticsearch.document.model.dsl.ElasticsearchJsonStringIndexSchemaFieldTypedContext;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaFieldNode;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaNodeCollector;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaNodeContributor;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaObjectNode;
import org.hibernate.search.backend.elasticsearch.document.model.impl.esnative.PropertyMapping;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.UnknownTypeJsonAccessor;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchJsonStringFieldCodec;
import org.hibernate.search.backend.elasticsearch.types.converter.impl.ElasticsearchStandardFieldConverter;
import org.hibernate.search.backend.elasticsearch.types.predicate.impl.ElasticsearchStandardFieldPredicateBuilderFactory;
import org.hibernate.search.backend.elasticsearch.types.projection.impl.ElasticsearchStandardFieldProjectionBuilderFactory;
import org.hibernate.search.backend.elasticsearch.types.sort.impl.ElasticsearchStandardFieldSortBuilderFactory;
import org.hibernate.search.engine.backend.document.IndexFieldAccessor;
import org.hibernate.search.engine.backend.document.converter.FromIndexFieldValueConverter;
import org.hibernate.search.engine.backend.document.converter.ToIndexFieldValueConverter;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexSchemaContext;
import org.hibernate.search.engine.backend.document.spi.IndexSchemaFieldDefinitionHelper;

public class ElasticsearchJsonStringIndexSchemaFieldContext
implements ElasticsearchJsonStringIndexSchemaFieldTypedContext,
ElasticsearchIndexSchemaNodeContributor<PropertyMapping> {
    private static final Gson GSON = new GsonBuilder().create();
    private static final ElasticsearchJsonStringFieldCodec CODEC = new ElasticsearchJsonStringFieldCodec(GSON);
    private final IndexSchemaFieldDefinitionHelper<String> helper;
    private final String relativeFieldName;
    private final String mappingJsonString;

    public ElasticsearchJsonStringIndexSchemaFieldContext(IndexSchemaContext schemaContext, String relativeFieldName, String mappingJsonString) {
        this.helper = new IndexSchemaFieldDefinitionHelper(schemaContext, String.class);
        this.relativeFieldName = relativeFieldName;
        this.mappingJsonString = mappingJsonString;
    }

    public ElasticsearchJsonStringIndexSchemaFieldContext dslConverter(ToIndexFieldValueConverter<?, ? extends String> toIndexConverter) {
        this.helper.dslConverter(toIndexConverter);
        return this;
    }

    public ElasticsearchJsonStringIndexSchemaFieldContext projectionConverter(FromIndexFieldValueConverter<? super String, ?> fromIndexConverter) {
        this.helper.projectionConverter(fromIndexConverter);
        return this;
    }

    public IndexFieldAccessor<String> createAccessor() {
        return this.helper.createAccessor();
    }

    @Override
    public PropertyMapping contribute(ElasticsearchIndexSchemaNodeCollector collector, ElasticsearchIndexSchemaObjectNode parentNode) {
        PropertyMapping mapping = (PropertyMapping)GSON.fromJson(this.mappingJsonString, PropertyMapping.class);
        ElasticsearchStandardFieldConverter<String> converter = new ElasticsearchStandardFieldConverter<String>(this.helper.createUserIndexFieldConverter(), CODEC);
        ElasticsearchIndexSchemaFieldNode<String> node = new ElasticsearchIndexSchemaFieldNode<String>(parentNode, converter, CODEC, new ElasticsearchStandardFieldPredicateBuilderFactory(converter), new ElasticsearchStandardFieldSortBuilderFactory(true, converter), new ElasticsearchStandardFieldProjectionBuilderFactory(true, converter));
        UnknownTypeJsonAccessor jsonAccessor = JsonAccessor.root().property(this.relativeFieldName);
        this.helper.initialize(new ElasticsearchIndexFieldAccessor<String>(jsonAccessor, node));
        String absoluteFieldPath = parentNode.getAbsolutePath(this.relativeFieldName);
        collector.collect(absoluteFieldPath, node);
        return mapping;
    }
}

