/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.dsl.impl;

import java.time.LocalDate;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.Arrays;
import java.util.Locale;
import org.hibernate.search.backend.elasticsearch.document.impl.ElasticsearchIndexFieldAccessor;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaFieldNode;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaNodeCollector;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaObjectNode;
import org.hibernate.search.backend.elasticsearch.document.model.impl.esnative.DataType;
import org.hibernate.search.backend.elasticsearch.document.model.impl.esnative.PropertyMapping;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.UnknownTypeJsonAccessor;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchLocalDateFieldCodec;
import org.hibernate.search.backend.elasticsearch.types.converter.impl.ElasticsearchStandardFieldConverter;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.AbstractElasticsearchScalarFieldTypedContext;
import org.hibernate.search.backend.elasticsearch.types.predicate.impl.ElasticsearchStandardFieldPredicateBuilderFactory;
import org.hibernate.search.backend.elasticsearch.types.projection.impl.ElasticsearchStandardFieldProjectionBuilderFactory;
import org.hibernate.search.backend.elasticsearch.types.sort.impl.ElasticsearchStandardFieldSortBuilderFactory;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexSchemaContext;
import org.hibernate.search.engine.backend.document.spi.IndexSchemaFieldDefinitionHelper;

public class ElasticsearchLocalDateIndexSchemaFieldContext
extends AbstractElasticsearchScalarFieldTypedContext<ElasticsearchLocalDateIndexSchemaFieldContext, LocalDate> {
    private static final ElasticsearchLocalDateFieldCodec DEFAULT_CODEC = new ElasticsearchLocalDateFieldCodec(new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 9, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).toFormatter(Locale.ROOT).withResolverStyle(ResolverStyle.STRICT));
    private final String relativeFieldName;
    private final ElasticsearchLocalDateFieldCodec codec = DEFAULT_CODEC;

    public ElasticsearchLocalDateIndexSchemaFieldContext(IndexSchemaContext schemaContext, String relativeFieldName) {
        super(schemaContext, LocalDate.class, DataType.DATE);
        this.relativeFieldName = relativeFieldName;
    }

    @Override
    protected PropertyMapping contribute(IndexSchemaFieldDefinitionHelper<LocalDate> helper, ElasticsearchIndexSchemaNodeCollector collector, ElasticsearchIndexSchemaObjectNode parentNode) {
        PropertyMapping mapping = super.contribute(helper, collector, parentNode);
        ElasticsearchStandardFieldConverter<LocalDate> converter = new ElasticsearchStandardFieldConverter<LocalDate>(helper.createUserIndexFieldConverter(), this.codec);
        ElasticsearchIndexSchemaFieldNode<LocalDate> node = new ElasticsearchIndexSchemaFieldNode<LocalDate>(parentNode, converter, this.codec, new ElasticsearchStandardFieldPredicateBuilderFactory(converter), new ElasticsearchStandardFieldSortBuilderFactory(this.resolvedSortable, converter), new ElasticsearchStandardFieldProjectionBuilderFactory(this.resolvedProjectable, converter));
        UnknownTypeJsonAccessor jsonAccessor = JsonAccessor.root().property(this.relativeFieldName);
        helper.initialize(new ElasticsearchIndexFieldAccessor<LocalDate>(jsonAccessor, node));
        mapping.setFormat(Arrays.asList("strict_date", "yyyyyyyyy-MM-dd"));
        String absoluteFieldPath = parentNode.getAbsolutePath(this.relativeFieldName);
        collector.collect(absoluteFieldPath, node);
        return mapping;
    }

    @Override
    protected ElasticsearchLocalDateIndexSchemaFieldContext thisAsS() {
        return this;
    }
}

