/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.dsl.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.backend.elasticsearch.document.impl.ElasticsearchIndexFieldAccessor;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaFieldNode;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaNodeCollector;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaObjectNode;
import org.hibernate.search.backend.elasticsearch.document.model.impl.esnative.DataType;
import org.hibernate.search.backend.elasticsearch.document.model.impl.esnative.PropertyMapping;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.UnknownTypeJsonAccessor;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchStringFieldCodec;
import org.hibernate.search.backend.elasticsearch.types.converter.impl.ElasticsearchStandardFieldConverter;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.AbstractElasticsearchStandardIndexSchemaFieldTypedContext;
import org.hibernate.search.backend.elasticsearch.types.predicate.impl.ElasticsearchStandardFieldPredicateBuilderFactory;
import org.hibernate.search.backend.elasticsearch.types.projection.impl.ElasticsearchStandardFieldProjectionBuilderFactory;
import org.hibernate.search.backend.elasticsearch.types.sort.impl.ElasticsearchStandardFieldSortBuilderFactory;
import org.hibernate.search.engine.backend.document.model.dsl.Projectable;
import org.hibernate.search.engine.backend.document.model.dsl.Sortable;
import org.hibernate.search.engine.backend.document.model.dsl.StringIndexSchemaFieldTypedContext;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexSchemaContext;
import org.hibernate.search.engine.backend.document.spi.IndexSchemaFieldDefinitionHelper;
import org.hibernate.search.util.impl.common.LoggerFactory;

public class ElasticsearchStringIndexSchemaFieldContext
extends AbstractElasticsearchStandardIndexSchemaFieldTypedContext<ElasticsearchStringIndexSchemaFieldContext, String>
implements StringIndexSchemaFieldTypedContext<ElasticsearchStringIndexSchemaFieldContext> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final String relativeFieldName;
    private String analyzerName;
    private String normalizerName;
    private Projectable projectable = Projectable.DEFAULT;
    private Sortable sortable = Sortable.DEFAULT;

    public ElasticsearchStringIndexSchemaFieldContext(IndexSchemaContext schemaContext, String relativeFieldName) {
        super(schemaContext, String.class);
        this.relativeFieldName = relativeFieldName;
    }

    public ElasticsearchStringIndexSchemaFieldContext analyzer(String analyzerName) {
        this.analyzerName = analyzerName;
        return this;
    }

    public ElasticsearchStringIndexSchemaFieldContext normalizer(String normalizerName) {
        this.normalizerName = normalizerName;
        return this;
    }

    public ElasticsearchStringIndexSchemaFieldContext projectable(Projectable projectable) {
        this.projectable = projectable;
        return this;
    }

    public ElasticsearchStringIndexSchemaFieldContext sortable(Sortable sortable) {
        this.sortable = sortable;
        return this;
    }

    @Override
    protected PropertyMapping contribute(IndexSchemaFieldDefinitionHelper<String> helper, ElasticsearchIndexSchemaNodeCollector collector, ElasticsearchIndexSchemaObjectNode parentNode) {
        PropertyMapping mapping = new PropertyMapping();
        boolean resolvedSortable = ElasticsearchStringIndexSchemaFieldContext.resolveDefault(this.sortable);
        boolean resolvedProjectable = ElasticsearchStringIndexSchemaFieldContext.resolveDefault(this.projectable);
        if (this.analyzerName != null) {
            mapping.setType(DataType.TEXT);
            mapping.setAnalyzer(this.analyzerName);
            if (this.normalizerName != null) {
                throw log.cannotApplyAnalyzerAndNormalizer(this.analyzerName, this.normalizerName, this.getSchemaContext().getEventContext());
            }
            if (resolvedSortable) {
                throw log.cannotUseAnalyzerOnSortableField(this.analyzerName, this.getSchemaContext().getEventContext());
            }
        } else {
            mapping.setType(DataType.KEYWORD);
            mapping.setNormalizer(this.normalizerName);
            mapping.setDocValues(resolvedSortable);
        }
        mapping.setStore(resolvedProjectable);
        ElasticsearchStandardFieldConverter<String> converter = new ElasticsearchStandardFieldConverter<String>(helper.createUserIndexFieldConverter(), ElasticsearchStringFieldCodec.INSTANCE);
        ElasticsearchIndexSchemaFieldNode<String> node = new ElasticsearchIndexSchemaFieldNode<String>(parentNode, converter, ElasticsearchStringFieldCodec.INSTANCE, new ElasticsearchStandardFieldPredicateBuilderFactory(converter), new ElasticsearchStandardFieldSortBuilderFactory(resolvedSortable, converter), new ElasticsearchStandardFieldProjectionBuilderFactory(resolvedProjectable, converter));
        UnknownTypeJsonAccessor jsonAccessor = JsonAccessor.root().property(this.relativeFieldName);
        helper.initialize(new ElasticsearchIndexFieldAccessor<String>(jsonAccessor, node));
        String absoluteFieldPath = parentNode.getAbsolutePath(this.relativeFieldName);
        collector.collect(absoluteFieldPath, node);
        return mapping;
    }

    @Override
    protected ElasticsearchStringIndexSchemaFieldContext thisAsS() {
        return this;
    }
}

