/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.predicate.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonObjectAccessor;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.AbstractElasticsearchSearchPredicateBuilder;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicateBuilder;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchFieldCodec;
import org.hibernate.search.engine.search.predicate.spi.SpatialWithinBoundingBoxPredicateBuilder;
import org.hibernate.search.engine.spatial.GeoBoundingBox;
import org.hibernate.search.engine.spatial.GeoPoint;

class ElasticsearchGeoPointSpatialWithinBoundingBoxPredicateBuilder
extends AbstractElasticsearchSearchPredicateBuilder
implements SpatialWithinBoundingBoxPredicateBuilder<ElasticsearchSearchPredicateBuilder> {
    private static final JsonObjectAccessor GEO_BOUNDING_BOX = JsonAccessor.root().property("geo_bounding_box").asObject();
    private static final String TOP_LEFT = "top_left";
    private static final String BOTTOM_RIGHT = "bottom_right";
    private final String absoluteFieldPath;
    private final ElasticsearchFieldCodec<GeoPoint> codec;

    ElasticsearchGeoPointSpatialWithinBoundingBoxPredicateBuilder(String absoluteFieldPath, ElasticsearchFieldCodec<GeoPoint> codec) {
        this.absoluteFieldPath = absoluteFieldPath;
        this.codec = codec;
    }

    public void boundingBox(GeoBoundingBox boundingBox) {
        this.getInnerObject().add(this.absoluteFieldPath, (JsonElement)this.toBoundingBoxObject(boundingBox));
    }

    @Override
    protected JsonObject doBuild() {
        JsonObject outerObject = this.getOuterObject();
        GEO_BOUNDING_BOX.set(outerObject, this.getInnerObject());
        return outerObject;
    }

    private JsonObject toBoundingBoxObject(GeoBoundingBox boundingBox) {
        JsonObject boundingBoxObject = new JsonObject();
        boundingBoxObject.add(TOP_LEFT, this.codec.encode(boundingBox.getTopLeft()));
        boundingBoxObject.add(BOTTOM_RIGHT, this.codec.encode(boundingBox.getBottomRight()));
        return boundingBoxObject;
    }
}

