/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.predicate.impl;

import com.google.gson.JsonObject;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonObjectAccessor;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.AbstractElasticsearchSearchPredicateBuilder;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicateBuilder;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchFieldCodec;
import org.hibernate.search.engine.search.predicate.spi.SpatialWithinCirclePredicateBuilder;
import org.hibernate.search.engine.spatial.DistanceUnit;
import org.hibernate.search.engine.spatial.GeoPoint;

class ElasticsearchGeoPointSpatialWithinCirclePredicateBuilder
extends AbstractElasticsearchSearchPredicateBuilder
implements SpatialWithinCirclePredicateBuilder<ElasticsearchSearchPredicateBuilder> {
    private static final JsonObjectAccessor GEO_DISTANCE = JsonAccessor.root().property("geo_distance").asObject();
    private static final JsonAccessor<Double> DISTANCE = JsonAccessor.root().property("distance").asDouble();
    private final String absoluteFieldPath;
    private final ElasticsearchFieldCodec<GeoPoint> codec;

    ElasticsearchGeoPointSpatialWithinCirclePredicateBuilder(String absoluteFieldPath, ElasticsearchFieldCodec<GeoPoint> codec) {
        this.absoluteFieldPath = absoluteFieldPath;
        this.codec = codec;
    }

    public void circle(GeoPoint center, double radius, DistanceUnit unit) {
        DISTANCE.set(this.getInnerObject(), unit.toMeters(radius));
        this.getInnerObject().add(this.absoluteFieldPath, this.codec.encode(center));
    }

    @Override
    protected JsonObject doBuild() {
        JsonObject outerObject = this.getOuterObject();
        GEO_DISTANCE.set(outerObject, this.getInnerObject());
        return outerObject;
    }
}

