/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.predicate.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonObjectAccessor;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.AbstractElasticsearchSearchPredicateBuilder;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.SpatialWithinPolygonPredicateBuilder;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.hibernate.search.engine.spatial.GeoPolygon;

class ElasticsearchGeoPointSpatialWithinPolygonPredicateBuilder
extends AbstractElasticsearchSearchPredicateBuilder
implements SpatialWithinPolygonPredicateBuilder<ElasticsearchSearchPredicateBuilder> {
    private static final JsonObjectAccessor GEO_POLYGON = JsonAccessor.root().property("geo_polygon").asObject();
    private static final String POINTS = "points";
    private final String absoluteFieldPath;

    ElasticsearchGeoPointSpatialWithinPolygonPredicateBuilder(String absoluteFieldPath) {
        this.absoluteFieldPath = absoluteFieldPath;
    }

    public void polygon(GeoPolygon polygon) {
        this.getInnerObject().add(this.absoluteFieldPath, (JsonElement)this.toPointsObject(polygon));
    }

    @Override
    protected JsonObject doBuild() {
        JsonObject outerObject = this.getOuterObject();
        GEO_POLYGON.set(outerObject, this.getInnerObject());
        return outerObject;
    }

    private JsonObject toPointsObject(GeoPolygon polygon) {
        JsonArray pointsArray = new JsonArray();
        for (GeoPoint point : polygon.getPoints()) {
            JsonArray pointArray = new JsonArray();
            pointArray.add((Number)point.getLongitude());
            pointArray.add((Number)point.getLatitude());
            pointsArray.add((JsonElement)pointArray);
        }
        JsonObject pointsObject = new JsonObject();
        pointsObject.add(POINTS, (JsonElement)pointsArray);
        return pointsObject;
    }
}

