/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.work.impl;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.search.backend.elasticsearch.client.impl.ElasticsearchRequest;
import org.hibernate.search.backend.elasticsearch.client.impl.Paths;
import org.hibernate.search.backend.elasticsearch.document.model.impl.esnative.RootTypeMapping;
import org.hibernate.search.backend.elasticsearch.gson.impl.GsonProvider;
import org.hibernate.search.backend.elasticsearch.index.settings.impl.esnative.IndexSettings;
import org.hibernate.search.backend.elasticsearch.util.impl.URLEncodedString;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchSearchResultExtractor;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchStubWork;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWork;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWorkFactory;
import org.hibernate.search.engine.search.SearchResult;

public class ElasticsearchStubWorkFactory
implements ElasticsearchWorkFactory {
    private final GsonProvider gsonProvider;

    public ElasticsearchStubWorkFactory(GsonProvider gsonProvider) {
        this.gsonProvider = gsonProvider;
    }

    @Override
    public ElasticsearchWork<?> dropIndexIfExists(URLEncodedString indexName) {
        ElasticsearchRequest.Builder builder = ElasticsearchRequest.delete().pathComponent(indexName);
        return new ElasticsearchStubWork(builder.build());
    }

    @Override
    public ElasticsearchWork<?> createIndex(URLEncodedString indexName, URLEncodedString typeName, RootTypeMapping mapping, IndexSettings settings) {
        Gson gson = this.gsonProvider.getGsonNoSerializeNulls();
        JsonObject mappingMap = new JsonObject();
        mappingMap.add(typeName.original, gson.toJsonTree((Object)mapping));
        JsonObject payload = new JsonObject();
        payload.add("mappings", (JsonElement)mappingMap);
        payload.add("settings", gson.toJsonTree((Object)settings));
        ElasticsearchRequest.Builder builder = ElasticsearchRequest.put().pathComponent(indexName).body(payload);
        return new ElasticsearchStubWork(builder.build());
    }

    @Override
    public ElasticsearchWork<?> add(URLEncodedString indexName, URLEncodedString typeName, String id, String routingKey, JsonObject document) {
        ElasticsearchRequest.Builder builder = ElasticsearchRequest.put().pathComponent(indexName).pathComponent(typeName).pathComponent(URLEncodedString.fromString(id)).body(document);
        builder.param("refresh", true);
        if (routingKey != null) {
            builder.param("_routing", routingKey);
        }
        return new ElasticsearchStubWork(builder.build());
    }

    @Override
    public ElasticsearchWork<?> update(URLEncodedString indexName, URLEncodedString typeName, String id, String routingKey, JsonObject document) {
        ElasticsearchRequest.Builder builder = ElasticsearchRequest.put().pathComponent(indexName).pathComponent(typeName).pathComponent(URLEncodedString.fromString(id)).body(document);
        builder.param("refresh", true);
        if (routingKey != null) {
            builder.param("_routing", routingKey);
        }
        return new ElasticsearchStubWork(builder.build());
    }

    @Override
    public ElasticsearchWork<?> delete(URLEncodedString indexName, URLEncodedString typeName, String id, String routingKey) {
        ElasticsearchRequest.Builder builder = ElasticsearchRequest.delete().pathComponent(indexName).pathComponent(typeName).pathComponent(URLEncodedString.fromString(id));
        builder.param("refresh", true);
        if (routingKey != null) {
            builder.param("_routing", routingKey);
        }
        return new ElasticsearchStubWork(builder.build());
    }

    @Override
    public ElasticsearchWork<?> flush(URLEncodedString indexName) {
        ElasticsearchRequest.Builder builder = ElasticsearchRequest.post().pathComponent(indexName).pathComponent(Paths._FLUSH);
        ElasticsearchStubWork flushWork = new ElasticsearchStubWork(builder.build());
        builder = ElasticsearchRequest.post().pathComponent(indexName).pathComponent(Paths._REFRESH);
        ElasticsearchStubWork refreshWork = new ElasticsearchStubWork(builder.build());
        return context -> flushWork.execute(context).thenCompose(ignored -> refreshWork.execute(context));
    }

    @Override
    public ElasticsearchWork<?> optimize(URLEncodedString indexName) {
        ElasticsearchRequest.Builder builder = ElasticsearchRequest.post().pathComponent(indexName).pathComponent(Paths._FORCEMERGE);
        return new ElasticsearchStubWork(builder.build());
    }

    @Override
    public <T> ElasticsearchWork<SearchResult<T>> search(Set<URLEncodedString> indexNames, Set<String> routingKeys, JsonObject payload, ElasticsearchSearchResultExtractor<T> searchResultExtractor, Long offset, Long limit) {
        ElasticsearchRequest.Builder builder = ElasticsearchRequest.post().multiValuedPathComponent(indexNames).pathComponent(Paths._SEARCH).body(payload);
        if (offset != null) {
            builder.param("from", offset);
        }
        if (limit != null) {
            builder.param("size", limit);
        }
        if (!routingKeys.isEmpty()) {
            builder.param("_routing", routingKeys.stream().collect(Collectors.joining(",")));
        }
        return new ElasticsearchStubWork<SearchResult<T>>(builder.build(), searchResultExtractor::extract);
    }
}

