/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.cfg;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public enum ElasticsearchIndexLifecycleStrategyName {
    NONE("none"),
    VALIDATE("validate"),
    UPDATE("update"),
    CREATE("create"),
    DROP_AND_CREATE("drop-and-create"),
    DROP_AND_CREATE_AND_DROP("drop-and-create-and-drop");

    private static final Map<String, ElasticsearchIndexLifecycleStrategyName> VALUES_BY_EXTERNAL_NAME;
    private final String externalName;

    public static ElasticsearchIndexLifecycleStrategyName fromExternalRepresentation(String propertyValue) {
        String normalizedName = propertyValue.trim().toLowerCase(Locale.ROOT);
        ElasticsearchIndexLifecycleStrategyName strategy = VALUES_BY_EXTERNAL_NAME.get(normalizedName);
        if (strategy == null) {
            throw new IllegalArgumentException("Unrecognized property value for an index management strategy: '" + propertyValue + "'. Please use one of " + VALUES_BY_EXTERNAL_NAME.keySet());
        }
        return strategy;
    }

    private ElasticsearchIndexLifecycleStrategyName(String propertyValue) {
        this.externalName = propertyValue;
    }

    public String getExternalName() {
        return this.externalName;
    }

    static {
        HashMap<String, ElasticsearchIndexLifecycleStrategyName> tmpMap = new HashMap<String, ElasticsearchIndexLifecycleStrategyName>();
        for (ElasticsearchIndexLifecycleStrategyName strategy : ElasticsearchIndexLifecycleStrategyName.values()) {
            tmpMap.put(strategy.externalName.toLowerCase(Locale.ROOT), strategy);
        }
        VALUES_BY_EXTERNAL_NAME = Collections.unmodifiableMap(tmpMap);
    }
}

