/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.cfg;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.util.impl.common.LoggerFactory;

public enum ElasticsearchIndexStatus {
    GREEN("green"),
    YELLOW("yellow"),
    RED("red");

    private static final Log log;
    private final String elasticsearchString;

    private ElasticsearchIndexStatus(String elasticsearchString) {
        this.elasticsearchString = elasticsearchString;
    }

    public String getElasticsearchString() {
        return this.elasticsearchString;
    }

    public static ElasticsearchIndexStatus fromExternalRepresentation(String status) {
        for (ElasticsearchIndexStatus indexStatus : ElasticsearchIndexStatus.values()) {
            if (!indexStatus.getElasticsearchString().equalsIgnoreCase(status)) continue;
            return indexStatus;
        }
        throw log.unexpectedIndexStatusString(status);
    }

    static {
        log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    }
}

