/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.client.impl;

import java.lang.invoke.MethodHandles;
import java.util.List;
import org.apache.http.HttpHost;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.util.impl.common.LoggerFactory;

final class ServerUris {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final HttpHost[] hosts;
    private final boolean anyHostRequiresSSL;

    private ServerUris(HttpHost[] hosts, boolean anyHostRequiresSSL) {
        this.hosts = hosts;
        this.anyHostRequiresSSL = anyHostRequiresSSL;
    }

    static ServerUris fromStrings(List<String> serverUrisStrings) {
        HttpHost[] hosts = new HttpHost[serverUrisStrings.size()];
        boolean anyHostRequiresSSL = false;
        for (int i = 0; i < serverUrisStrings.size(); ++i) {
            HttpHost host;
            hosts[i] = host = HttpHost.create((String)serverUrisStrings.get(i));
            String scheme = host.getSchemeName();
            if (!"https".equals(scheme)) continue;
            anyHostRequiresSSL = true;
        }
        return new ServerUris(hosts, anyHostRequiresSSL);
    }

    HttpHost[] asHostsArray() {
        return this.hosts;
    }

    boolean isAnyRequiringSSL() {
        return this.anyHostRequiresSSL;
    }

    void warnPasswordsOverHttp() {
        for (HttpHost host : this.hosts) {
            if (!"http".equals(host.getSchemeName())) continue;
            log.usingPasswordOverHttp(host.toURI());
        }
    }
}

