/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.document.impl;

import com.google.gson.JsonObject;
import org.hibernate.search.backend.elasticsearch.document.impl.ElasticsearchDocumentObjectBuilder;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaObjectNode;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.engine.backend.document.DocumentElement;
import org.hibernate.search.engine.backend.document.IndexObjectFieldAccessor;

public class ElasticsearchIndexObjectFieldAccessor
implements IndexObjectFieldAccessor {
    private final JsonAccessor<JsonObject> relativeAccessor;
    private final ElasticsearchIndexSchemaObjectNode schemaNode;

    public ElasticsearchIndexObjectFieldAccessor(JsonAccessor<JsonObject> relativeAccessor, ElasticsearchIndexSchemaObjectNode schemaNode) {
        this.relativeAccessor = relativeAccessor;
        this.schemaNode = schemaNode;
    }

    public DocumentElement add(DocumentElement target) {
        ElasticsearchDocumentObjectBuilder builder = (ElasticsearchDocumentObjectBuilder)target;
        builder.checkTreeConsistency(this.schemaNode.getParent());
        JsonObject jsonObject = new JsonObject();
        builder.add(this.relativeAccessor, jsonObject);
        return new ElasticsearchDocumentObjectBuilder(this.schemaNode, jsonObject);
    }

    public void addMissing(DocumentElement target) {
        ElasticsearchDocumentObjectBuilder builder = (ElasticsearchDocumentObjectBuilder)target;
        builder.checkTreeConsistency(this.schemaNode.getParent());
        builder.add(this.relativeAccessor, null);
    }
}

