/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.document.model.dsl.impl;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.search.backend.elasticsearch.document.model.dsl.impl.AbstractElasticsearchIndexSchemaObjectNodeBuilder;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexModel;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaFieldNode;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaNodeCollector;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaObjectNode;
import org.hibernate.search.backend.elasticsearch.document.model.impl.esnative.DynamicType;
import org.hibernate.search.backend.elasticsearch.document.model.impl.esnative.RootTypeMapping;
import org.hibernate.search.backend.elasticsearch.document.model.impl.esnative.RoutingType;
import org.hibernate.search.backend.elasticsearch.index.settings.impl.ElasticsearchIndexSettingsBuilder;
import org.hibernate.search.backend.elasticsearch.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.elasticsearch.types.dsl.ElasticsearchIndexFieldTypeFactoryContext;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexSchemaRootNodeBuilder;
import org.hibernate.search.engine.backend.types.converter.spi.StringToDocumentIdentifierValueConverter;
import org.hibernate.search.engine.backend.types.converter.spi.ToDocumentIdentifierValueConverter;
import org.hibernate.search.engine.logging.spi.EventContexts;
import org.hibernate.search.util.EventContext;

public class ElasticsearchIndexSchemaRootNodeBuilder
extends AbstractElasticsearchIndexSchemaObjectNodeBuilder
implements IndexSchemaRootNodeBuilder {
    private final EventContext indexEventContext;
    private final MultiTenancyStrategy multiTenancyStrategy;
    private final ElasticsearchIndexFieldTypeFactoryContext typeFactory;
    private RoutingType routing = null;
    private ToDocumentIdentifierValueConverter<?> idDslConverter;

    public ElasticsearchIndexSchemaRootNodeBuilder(EventContext indexEventContext, MultiTenancyStrategy multiTenancyStrategy, ElasticsearchIndexFieldTypeFactoryContext typeFactory) {
        this.indexEventContext = indexEventContext;
        this.multiTenancyStrategy = multiTenancyStrategy;
        this.typeFactory = typeFactory;
    }

    public EventContext getEventContext() {
        return this.getIndexEventContext().append(EventContexts.indexSchemaRoot());
    }

    public ElasticsearchIndexFieldTypeFactoryContext getTypeFactory() {
        return this.typeFactory;
    }

    public void explicitRouting() {
        this.routing = RoutingType.REQUIRED;
    }

    public void idDslConverter(ToDocumentIdentifierValueConverter<?> idDslConverter) {
        this.idDslConverter = idDslConverter;
    }

    public ElasticsearchIndexModel build(String hibernateSearchIndexName, URLEncodedString elasticsearchIndexName, ElasticsearchIndexSettingsBuilder settingsBuilder) {
        RootTypeMapping mapping = new RootTypeMapping();
        if (this.routing != null) {
            mapping.setRouting(this.routing);
        }
        this.multiTenancyStrategy.contributeToMapping(mapping);
        mapping.setDynamic(DynamicType.STRICT);
        final HashMap<String, ElasticsearchIndexSchemaObjectNode> objectNodes = new HashMap<String, ElasticsearchIndexSchemaObjectNode>();
        final HashMap fieldNodes = new HashMap();
        ElasticsearchIndexSchemaNodeCollector collector = new ElasticsearchIndexSchemaNodeCollector(){

            @Override
            public void collect(String absolutePath, ElasticsearchIndexSchemaObjectNode node) {
                objectNodes.put(absolutePath, node);
            }

            @Override
            public void collect(String absoluteFieldPath, ElasticsearchIndexSchemaFieldNode<?> node) {
                fieldNodes.put(absoluteFieldPath, node);
            }
        };
        ElasticsearchIndexSchemaObjectNode rootNode = ElasticsearchIndexSchemaObjectNode.root();
        this.contributeChildren(mapping, rootNode, collector);
        return new ElasticsearchIndexModel(hibernateSearchIndexName, elasticsearchIndexName, settingsBuilder, mapping, (ToDocumentIdentifierValueConverter<?>)(this.idDslConverter == null ? new StringToDocumentIdentifierValueConverter() : this.idDslConverter), (Map<String, ElasticsearchIndexSchemaObjectNode>)objectNodes, fieldNodes);
    }

    @Override
    ElasticsearchIndexSchemaRootNodeBuilder getRootNodeBuilder() {
        return this;
    }

    @Override
    String getAbsolutePath() {
        return null;
    }

    EventContext getIndexEventContext() {
        return this.indexEventContext;
    }
}

