/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.gson.spi;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.PrintWriter;
import java.io.StringWriter;

public final class JsonLogHelper {
    private static final JsonLogHelper INSTANCE = JsonLogHelper.create(new GsonBuilder(), true);
    private final Gson gson;
    private final boolean prettyPrinting;

    public static JsonLogHelper get() {
        return INSTANCE;
    }

    public static JsonLogHelper create(GsonBuilder gsonBuilder, boolean prettyPrinting) {
        if (prettyPrinting) {
            gsonBuilder.setPrettyPrinting();
        }
        return new JsonLogHelper(gsonBuilder.create(), prettyPrinting);
    }

    private JsonLogHelper(Gson gson, boolean prettyPrinting) {
        this.gson = gson;
        this.prettyPrinting = prettyPrinting;
    }

    public String toString(JsonObject object) {
        StringBuilder stringBuilder = new StringBuilder();
        this.append(stringBuilder, object);
        return stringBuilder.toString();
    }

    public void append(StringBuilder sb, JsonObject object) {
        this.beforeValue(sb);
        this.doAppend(sb, object);
        this.afterValue(sb);
    }

    public String toString(Iterable<JsonObject> objects) {
        StringBuilder sb = new StringBuilder(180);
        this.append(sb, objects);
        return sb.toString();
    }

    public void append(StringBuilder sb, Iterable<JsonObject> objects) {
        boolean first = true;
        this.beforeValue(sb);
        for (JsonObject object : objects) {
            if (first) {
                first = false;
            } else if (this.prettyPrinting) {
                sb.append("\n");
            } else {
                sb.append("\\n");
            }
            this.doAppend(sb, object);
        }
        this.afterValue(sb);
    }

    public JsonElement property(JsonObject parent, String name) {
        if (parent == null) {
            return null;
        }
        return parent.get(name);
    }

    private void beforeValue(StringBuilder sb) {
        if (this.prettyPrinting) {
            sb.append("\n");
        }
    }

    private void doAppend(StringBuilder sb, JsonObject object) {
        try {
            this.gson.toJson((JsonElement)object, (Appendable)sb);
        }
        catch (RuntimeException e) {
            StringWriter writer = new StringWriter();
            e.printStackTrace(new PrintWriter(writer));
            sb.append(writer.toString());
        }
    }

    private void afterValue(StringBuilder sb) {
        if (this.prettyPrinting) {
            sb.append("\n");
        }
    }
}

