/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.Closeable;
import java.lang.invoke.MethodHandles;
import java.util.Locale;
import org.hibernate.search.backend.elasticsearch.analysis.ElasticsearchAnalysisConfigurer;
import org.hibernate.search.backend.elasticsearch.analysis.model.dsl.impl.ElasticsearchAnalysisDefinitionContainerContextImpl;
import org.hibernate.search.backend.elasticsearch.analysis.model.impl.ElasticsearchAnalysisDefinitionRegistry;
import org.hibernate.search.backend.elasticsearch.cfg.ElasticsearchBackendSettings;
import org.hibernate.search.backend.elasticsearch.cfg.MultiTenancyStrategyName;
import org.hibernate.search.backend.elasticsearch.cfg.spi.ElasticsearchBackendSpiSettings;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchClientFactory;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchClientImplementor;
import org.hibernate.search.backend.elasticsearch.document.model.impl.esnative.FieldDataType;
import org.hibernate.search.backend.elasticsearch.document.model.impl.esnative.IndexType;
import org.hibernate.search.backend.elasticsearch.document.model.impl.esnative.NormsType;
import org.hibernate.search.backend.elasticsearch.gson.impl.DefaultGsonProvider;
import org.hibernate.search.backend.elasticsearch.gson.impl.ES5FieldDataTypeJsonAdapter;
import org.hibernate.search.backend.elasticsearch.gson.impl.ES5IndexTypeJsonAdapter;
import org.hibernate.search.backend.elasticsearch.gson.impl.ES5NormsTypeJsonAdapter;
import org.hibernate.search.backend.elasticsearch.gson.spi.GsonProvider;
import org.hibernate.search.backend.elasticsearch.impl.ElasticsearchBackendImpl;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.multitenancy.impl.DiscriminatorMultiTenancyStrategy;
import org.hibernate.search.backend.elasticsearch.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.elasticsearch.multitenancy.impl.NoMultiTenancyStrategy;
import org.hibernate.search.backend.elasticsearch.work.builder.factory.impl.ElasticsearchWorkBuilderFactoryImpl;
import org.hibernate.search.engine.backend.spi.BackendBuildContext;
import org.hibernate.search.engine.backend.spi.BackendFactory;
import org.hibernate.search.engine.backend.spi.BackendImplementor;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.OptionalConfigurationProperty;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanProvider;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.logging.spi.EventContexts;
import org.hibernate.search.util.AssertionFailure;
import org.hibernate.search.util.EventContext;
import org.hibernate.search.util.impl.common.LoggerFactory;
import org.hibernate.search.util.impl.common.SuppressingCloser;

public class ElasticsearchBackendFactory
implements BackendFactory {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final ConfigurationProperty<MultiTenancyStrategyName> MULTI_TENANCY_STRATEGY = ConfigurationProperty.forKey((String)"multi_tenancy_strategy").as(MultiTenancyStrategyName.class, MultiTenancyStrategyName::fromExternalRepresentation).withDefault((Object)ElasticsearchBackendSettings.Defaults.MULTI_TENANCY_STRATEGY).build();
    private static final ConfigurationProperty<Boolean> LOG_JSON_PRETTY_PRINTING = ConfigurationProperty.forKey((String)"log.json_pretty_printing").asBoolean().withDefault((Object)false).build();
    private static final ConfigurationProperty<BeanReference<? extends ElasticsearchClientFactory>> CLIENT_FACTORY = ConfigurationProperty.forKey((String)"client_factory").asBeanReference(ElasticsearchClientFactory.class).withDefault(ElasticsearchBackendSpiSettings.Defaults.CLIENT_FACTORY).build();
    private static final OptionalConfigurationProperty<BeanReference<? extends ElasticsearchAnalysisConfigurer>> ANALYSIS_CONFIGURER = ConfigurationProperty.forKey((String)"analysis_configurer").asBeanReference(ElasticsearchAnalysisConfigurer.class).build();

    public BackendImplementor<?> create(String name, BackendBuildContext buildContext, ConfigurationPropertySource propertySource) {
        EventContext backendContext = EventContexts.fromBackendName((String)name);
        boolean logPrettyPrinting = (Boolean)LOG_JSON_PRETTY_PRINTING.get(propertySource);
        GsonProvider initialGsonProvider = DefaultGsonProvider.create(GsonBuilder::new, logPrettyPrinting);
        ElasticsearchClientImplementor client = null;
        try {
            BeanProvider beanProvider = buildContext.getServiceManager().getBeanProvider();
            try (BeanHolder clientFactoryHolder = (BeanHolder)CLIENT_FACTORY.getAndTransform(propertySource, arg_0 -> ((BeanProvider)beanProvider).getBean(arg_0));){
                client = ((ElasticsearchClientFactory)clientFactoryHolder.get()).create(propertySource, initialGsonProvider);
            }
            GsonProvider dialectSpecificGsonProvider = DefaultGsonProvider.create(this::createES5GsonBuilderBase, logPrettyPrinting);
            client.init(dialectSpecificGsonProvider);
            Gson userFacingGson = new GsonBuilder().setPrettyPrinting().create();
            ElasticsearchWorkBuilderFactoryImpl workFactory = new ElasticsearchWorkBuilderFactoryImpl(dialectSpecificGsonProvider);
            ElasticsearchAnalysisDefinitionRegistry analysisDefinitionRegistry = this.getAnalysisDefinitionRegistry(backendContext, buildContext, propertySource);
            return new ElasticsearchBackendImpl(client, dialectSpecificGsonProvider, name, workFactory, userFacingGson, analysisDefinitionRegistry, this.getMultiTenancyStrategy(name, propertySource));
        }
        catch (RuntimeException e) {
            new SuppressingCloser((Throwable)e).push(Closeable::close, client);
            throw e;
        }
    }

    private GsonBuilder createES5GsonBuilderBase() {
        return new GsonBuilder().registerTypeAdapter(IndexType.class, (Object)new ES5IndexTypeJsonAdapter().nullSafe()).registerTypeAdapter(FieldDataType.class, (Object)new ES5FieldDataTypeJsonAdapter().nullSafe()).registerTypeAdapter(NormsType.class, (Object)new ES5NormsTypeJsonAdapter().nullSafe());
    }

    private MultiTenancyStrategy getMultiTenancyStrategy(String backendName, ConfigurationPropertySource propertySource) {
        MultiTenancyStrategyName multiTenancyStrategyName = (MultiTenancyStrategyName)((Object)MULTI_TENANCY_STRATEGY.get(propertySource));
        switch (multiTenancyStrategyName) {
            case NONE: {
                return new NoMultiTenancyStrategy();
            }
            case DISCRIMINATOR: {
                return new DiscriminatorMultiTenancyStrategy();
            }
        }
        throw new AssertionFailure(String.format(Locale.ROOT, "Unsupported multi-tenancy strategy '%2$s' for backend '%1$s'", new Object[]{backendName, multiTenancyStrategyName}));
    }

    private ElasticsearchAnalysisDefinitionRegistry getAnalysisDefinitionRegistry(EventContext backendContext, BackendBuildContext buildContext, ConfigurationPropertySource propertySource) {
        try {
            BeanProvider beanProvider = buildContext.getServiceManager().getBeanProvider();
            return ANALYSIS_CONFIGURER.getAndMap(propertySource, arg_0 -> ((BeanProvider)beanProvider).getBean(arg_0)).map(holder -> {
                try (BeanHolder configurerHolder = holder;){
                    ElasticsearchAnalysisDefinitionContainerContextImpl collector = new ElasticsearchAnalysisDefinitionContainerContextImpl();
                    ((ElasticsearchAnalysisConfigurer)configurerHolder.get()).configure(collector);
                    ElasticsearchAnalysisDefinitionRegistry elasticsearchAnalysisDefinitionRegistry = new ElasticsearchAnalysisDefinitionRegistry(collector);
                    return elasticsearchAnalysisDefinitionRegistry;
                }
            }).orElseGet(ElasticsearchAnalysisDefinitionRegistry::new);
        }
        catch (Exception e) {
            throw log.unableToApplyAnalysisConfiguration(e.getMessage(), backendContext, e);
        }
    }
}

