/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.impl;

import com.google.gson.Gson;
import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.search.backend.elasticsearch.ElasticsearchBackend;
import org.hibernate.search.backend.elasticsearch.analysis.model.impl.ElasticsearchAnalysisDefinitionRegistry;
import org.hibernate.search.backend.elasticsearch.cfg.ElasticsearchIndexLifecycleStrategyName;
import org.hibernate.search.backend.elasticsearch.cfg.ElasticsearchIndexSettings;
import org.hibernate.search.backend.elasticsearch.cfg.ElasticsearchIndexStatus;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchClientImplementor;
import org.hibernate.search.backend.elasticsearch.document.impl.ElasticsearchDocumentObjectBuilder;
import org.hibernate.search.backend.elasticsearch.document.model.dsl.impl.ElasticsearchIndexSchemaRootNodeBuilder;
import org.hibernate.search.backend.elasticsearch.gson.spi.GsonProvider;
import org.hibernate.search.backend.elasticsearch.impl.ElasticsearchIndexNameNormalizer;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ElasticsearchIndexLifecycleExecutionOptions;
import org.hibernate.search.backend.elasticsearch.index.impl.ElasticsearchIndexManagerBuilder;
import org.hibernate.search.backend.elasticsearch.index.impl.IndexingBackendContext;
import org.hibernate.search.backend.elasticsearch.index.management.impl.ElasticsearchIndexLifecycleStrategy;
import org.hibernate.search.backend.elasticsearch.index.settings.impl.ElasticsearchIndexSettingsBuilder;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkOrchestratorProvider;
import org.hibernate.search.backend.elasticsearch.search.query.impl.SearchBackendContext;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchIndexFieldTypeFactoryContextImpl;
import org.hibernate.search.backend.elasticsearch.work.builder.factory.impl.ElasticsearchWorkBuilderFactory;
import org.hibernate.search.engine.backend.Backend;
import org.hibernate.search.engine.backend.index.spi.IndexManagerBuilder;
import org.hibernate.search.engine.backend.spi.BackendBuildContext;
import org.hibernate.search.engine.backend.spi.BackendImplementor;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.common.spi.ErrorHandler;
import org.hibernate.search.engine.common.spi.LogErrorHandler;
import org.hibernate.search.engine.logging.spi.EventContexts;
import org.hibernate.search.util.EventContext;
import org.hibernate.search.util.impl.common.Closer;
import org.hibernate.search.util.impl.common.LoggerFactory;

class ElasticsearchBackendImpl
implements BackendImplementor<ElasticsearchDocumentObjectBuilder>,
ElasticsearchBackend {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final ConfigurationProperty<Boolean> REFRESH_AFTER_WRITE = ConfigurationProperty.forKey((String)"refresh_after_write").asBoolean().withDefault((Object)false).build();
    private static final ConfigurationProperty<ElasticsearchIndexLifecycleStrategyName> LIFECYCLE_STRATEGY = ConfigurationProperty.forKey((String)"lifecycle.strategy").as(ElasticsearchIndexLifecycleStrategyName.class, ElasticsearchIndexLifecycleStrategyName::fromExternalRepresentation).withDefault((Object)ElasticsearchIndexSettings.Defaults.LIFECYCLE_STRATEGY).build();
    private static final ConfigurationProperty<ElasticsearchIndexStatus> MANAGEMENT_REQUIRED_STATUS = ConfigurationProperty.forKey((String)"lifecycle.required_status").as(ElasticsearchIndexStatus.class, ElasticsearchIndexStatus::fromExternalRepresentation).withDefault((Object)ElasticsearchIndexSettings.Defaults.LIFECYCLE_REQUIRED_STATUS).build();
    private static final ConfigurationProperty<Integer> MANAGEMENT_REQUIRED_STATUS_WAIT_TIMEOUT = ConfigurationProperty.forKey((String)"lifecycle.required_status_wait_timeout").asInteger().withDefault((Object)10000).build();
    private final ElasticsearchClientImplementor client;
    private final String name;
    private final ElasticsearchWorkOrchestratorProvider orchestratorProvider;
    private final Gson userFacingGson;
    private final ElasticsearchAnalysisDefinitionRegistry analysisDefinitionRegistry;
    private final MultiTenancyStrategy multiTenancyStrategy;
    private final ElasticsearchWorkOrchestrator queryOrchestrator;
    private final Map<String, String> hibernateSearchIndexNamesByElasticsearchIndexNames = new ConcurrentHashMap<String, String>();
    private final EventContext eventContext;
    private final IndexingBackendContext indexingContext;
    private final SearchBackendContext searchContext;

    ElasticsearchBackendImpl(ElasticsearchClientImplementor client, GsonProvider gsonProvider, String name, ElasticsearchWorkBuilderFactory workFactory, Gson userFacingGson, ElasticsearchAnalysisDefinitionRegistry analysisDefinitionRegistry, MultiTenancyStrategy multiTenancyStrategy) {
        this.client = client;
        this.name = name;
        this.orchestratorProvider = new ElasticsearchWorkOrchestratorProvider("Elasticsearch parallel work orchestrator for backend " + name, client, gsonProvider, workFactory, (ErrorHandler)new LogErrorHandler());
        this.userFacingGson = userFacingGson;
        this.analysisDefinitionRegistry = analysisDefinitionRegistry;
        this.multiTenancyStrategy = multiTenancyStrategy;
        this.queryOrchestrator = this.orchestratorProvider.createParallelOrchestrator("Elasticsearch query orchestrator for backend " + name);
        this.eventContext = EventContexts.fromBackendName((String)name);
        this.indexingContext = new IndexingBackendContext(this.eventContext, workFactory, multiTenancyStrategy, this.orchestratorProvider);
        this.searchContext = new SearchBackendContext(this.eventContext, workFactory, userFacingGson, elasticsearchIndexName -> {
            String result = this.hibernateSearchIndexNamesByElasticsearchIndexNames.get(elasticsearchIndexName);
            if (result == null) {
                throw log.elasticsearchResponseUnknownIndexName((String)elasticsearchIndexName, this.eventContext);
            }
            return result;
        }, multiTenancyStrategy, this.queryOrchestrator);
    }

    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isAssignableFrom(ElasticsearchBackend.class)) {
            return (T)this;
        }
        throw log.backendUnwrappingWithUnknownType(clazz, ElasticsearchBackend.class, this.eventContext);
    }

    public Backend toAPI() {
        return this;
    }

    @Override
    public <T> T getClient(Class<T> clientClass) {
        return this.client.unwrap(clientClass);
    }

    public IndexManagerBuilder<ElasticsearchDocumentObjectBuilder> createIndexManagerBuilder(String hibernateSearchIndexName, boolean multiTenancyEnabled, BackendBuildContext buildContext, ConfigurationPropertySource propertySource) {
        if (multiTenancyEnabled && !this.multiTenancyStrategy.isMultiTenancySupported()) {
            throw log.multiTenancyRequiredButNotSupportedByBackend(hibernateSearchIndexName, this.eventContext);
        }
        String elasticsearchIndexName = ElasticsearchIndexNameNormalizer.normalize(hibernateSearchIndexName);
        String existingHibernateSearchIndexName = this.hibernateSearchIndexNamesByElasticsearchIndexNames.putIfAbsent(elasticsearchIndexName, hibernateSearchIndexName);
        if (existingHibernateSearchIndexName != null) {
            throw log.duplicateNormalizedIndexNames(existingHibernateSearchIndexName, hibernateSearchIndexName, elasticsearchIndexName, this.eventContext);
        }
        EventContext indexEventContext = EventContexts.fromIndexName((String)hibernateSearchIndexName);
        ElasticsearchIndexFieldTypeFactoryContextImpl typeFactoryContext = new ElasticsearchIndexFieldTypeFactoryContextImpl(indexEventContext, this.userFacingGson);
        ElasticsearchIndexSchemaRootNodeBuilder indexSchemaRootNodeBuilder = new ElasticsearchIndexSchemaRootNodeBuilder(indexEventContext, this.multiTenancyStrategy, typeFactoryContext);
        ElasticsearchIndexSettingsBuilder settingsBuilder = new ElasticsearchIndexSettingsBuilder(this.analysisDefinitionRegistry);
        boolean refreshAfterWrite = (Boolean)REFRESH_AFTER_WRITE.get(propertySource);
        ElasticsearchIndexLifecycleStrategy lifecycleStrategy = this.createIndexLifecycleStrategy(propertySource);
        return new ElasticsearchIndexManagerBuilder(this.indexingContext, this.searchContext, hibernateSearchIndexName, elasticsearchIndexName, indexSchemaRootNodeBuilder, settingsBuilder, lifecycleStrategy, refreshAfterWrite);
    }

    private ElasticsearchIndexLifecycleStrategy createIndexLifecycleStrategy(ConfigurationPropertySource propertySource) {
        return new ElasticsearchIndexLifecycleStrategy((ElasticsearchIndexLifecycleStrategyName)((Object)LIFECYCLE_STRATEGY.get(propertySource)), new ElasticsearchIndexLifecycleExecutionOptions((ElasticsearchIndexStatus)((Object)MANAGEMENT_REQUIRED_STATUS.get(propertySource)), (Integer)MANAGEMENT_REQUIRED_STATUS_WAIT_TIMEOUT.get(propertySource)));
    }

    public void close() {
        try (Closer closer = new Closer();){
            closer.push(ElasticsearchWorkOrchestrator::close, (Object)this.queryOrchestrator);
            closer.push(ElasticsearchWorkOrchestratorProvider::close, (Object)this.orchestratorProvider);
            closer.push(Closeable::close, (Object)this.client);
        }
        catch (IOException | RuntimeException e) {
            throw log.failedToShutdownBackend(e, this.eventContext);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "name=" + this.name + "]";
    }
}

