/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.index.admin.gson.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Map;
import java.util.Objects;

public class AnalysisJsonElementEquivalence {
    private final AnalysisJsonElementEquivalence nestedEquivalence;

    public AnalysisJsonElementEquivalence() {
        this.nestedEquivalence = this;
    }

    public AnalysisJsonElementEquivalence(AnalysisJsonElementEquivalence itemEquivalence) {
        this.nestedEquivalence = itemEquivalence;
    }

    public boolean isEquivalent(JsonElement left, JsonElement right) {
        if (left == null || right == null) {
            return left == right;
        }
        if (left.isJsonPrimitive() && right.isJsonPrimitive()) {
            return this.isPrimitiveEquivalent(left.getAsJsonPrimitive(), right.getAsJsonPrimitive());
        }
        if (left.isJsonArray() && right.isJsonArray()) {
            return this.isArrayEquivalent(left.getAsJsonArray(), right.getAsJsonArray());
        }
        if (left.isJsonObject() && right.isJsonObject()) {
            return this.isObjectEquivalent(left.getAsJsonObject(), right.getAsJsonObject());
        }
        return this.isElementEquivalent(left, right);
    }

    protected boolean isPrimitiveEquivalent(JsonPrimitive left, JsonPrimitive right) {
        return Objects.equals(left.getAsString(), right.getAsString());
    }

    protected boolean isArrayEquivalent(JsonArray left, JsonArray right) {
        if (left == null || right == null) {
            return left == right;
        }
        if (left.size() != right.size()) {
            return false;
        }
        int size = left.size();
        for (int i = 0; i < size; ++i) {
            if (this.isNestedEquivalent(left.get(i), right.get(i))) continue;
            return false;
        }
        return true;
    }

    protected boolean isObjectEquivalent(JsonObject left, JsonObject right) {
        JsonElement rightValue;
        JsonElement leftValue;
        String propertyName;
        for (Map.Entry leftEntry : left.entrySet()) {
            propertyName = (String)leftEntry.getKey();
            leftValue = (JsonElement)leftEntry.getValue();
            if (this.isNestedEquivalent(leftValue, rightValue = right.get(propertyName))) continue;
            return false;
        }
        for (Map.Entry rightEntry : right.entrySet()) {
            propertyName = (String)rightEntry.getKey();
            if (left.has(propertyName) || this.isNestedEquivalent(leftValue = null, rightValue = (JsonElement)rightEntry.getValue())) continue;
            return false;
        }
        return true;
    }

    protected boolean isNestedEquivalent(JsonElement left, JsonElement right) {
        return this.nestedEquivalence.isEquivalent(left, right);
    }

    protected boolean isElementEquivalent(JsonElement left, JsonElement right) {
        return Objects.equals(left, right);
    }
}

