/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.index.admin.impl;

import org.hibernate.search.backend.elasticsearch.index.admin.impl.ElasticsearchIndexLifecycleExecutionOptions;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ElasticsearchSchemaAccessor;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ElasticsearchSchemaCreator;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ElasticsearchSchemaCreatorImpl;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ElasticsearchSchemaDropper;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ElasticsearchSchemaDropperImpl;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ElasticsearchSchemaMigrator;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ElasticsearchSchemaMigratorImpl;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ElasticsearchSchemaValidator;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ElasticsearchSchemaValidatorImpl;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.IndexMetadata;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.backend.elasticsearch.work.builder.factory.impl.ElasticsearchWorkBuilderFactory;

public class ElasticsearchIndexAdministrationClient {
    private final ElasticsearchSchemaCreator schemaCreator;
    private final ElasticsearchSchemaDropper schemaDropper;
    private final ElasticsearchSchemaValidator schemaValidator;
    private final ElasticsearchSchemaMigrator schemaMigrator;
    private final URLEncodedString elasticsearchIndexName;
    private final IndexMetadata expectedMetadata;

    public ElasticsearchIndexAdministrationClient(ElasticsearchWorkBuilderFactory workFactory, ElasticsearchWorkOrchestrator workOrchestrator, URLEncodedString elasticsearchIndexName, IndexMetadata expectedMetadata) {
        ElasticsearchSchemaAccessor schemaAccessor = new ElasticsearchSchemaAccessor(workFactory, workOrchestrator);
        this.schemaCreator = new ElasticsearchSchemaCreatorImpl(schemaAccessor);
        this.schemaDropper = new ElasticsearchSchemaDropperImpl(schemaAccessor);
        this.schemaValidator = new ElasticsearchSchemaValidatorImpl(schemaAccessor);
        this.schemaMigrator = new ElasticsearchSchemaMigratorImpl(schemaAccessor, this.schemaValidator);
        this.elasticsearchIndexName = elasticsearchIndexName;
        this.expectedMetadata = expectedMetadata;
    }

    public void createIfAbsent(ElasticsearchIndexLifecycleExecutionOptions executionOptions) {
        this.schemaCreator.createIndexIfAbsent(this.expectedMetadata, executionOptions);
    }

    public void dropAndCreate(ElasticsearchIndexLifecycleExecutionOptions executionOptions) {
        this.schemaDropper.dropIfExisting(this.elasticsearchIndexName, executionOptions);
        this.schemaCreator.createIndex(this.expectedMetadata, executionOptions);
    }

    public void dropIfExisting(ElasticsearchIndexLifecycleExecutionOptions executionOptions) {
        this.schemaDropper.dropIfExisting(this.elasticsearchIndexName, executionOptions);
    }

    public void update(ElasticsearchIndexLifecycleExecutionOptions executionOptions) {
        boolean createdIndex = this.schemaCreator.createIndexIfAbsent(this.expectedMetadata, executionOptions);
        if (!createdIndex) {
            this.schemaMigrator.migrate(this.expectedMetadata, executionOptions);
        }
    }

    public void validate(ElasticsearchIndexLifecycleExecutionOptions executionOptions) {
        this.schemaCreator.checkIndexExists(this.elasticsearchIndexName, executionOptions);
        this.schemaValidator.validate(this.expectedMetadata, executionOptions);
    }
}

