/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.index.admin.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ElasticsearchIndexLifecycleExecutionOptions;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ElasticsearchSchemaAccessor;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ElasticsearchSchemaMigrator;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ElasticsearchSchemaValidator;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.IndexMetadata;
import org.hibernate.search.backend.elasticsearch.index.settings.impl.esnative.IndexSettings;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.util.SearchException;
import org.hibernate.search.util.impl.common.LoggerFactory;

public class ElasticsearchSchemaMigratorImpl
implements ElasticsearchSchemaMigrator {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final ElasticsearchSchemaAccessor schemaAccessor;
    private final ElasticsearchSchemaValidator schemaValidator;

    public ElasticsearchSchemaMigratorImpl(ElasticsearchSchemaAccessor schemaAccessor, ElasticsearchSchemaValidator schemaValidator) {
        this.schemaAccessor = schemaAccessor;
        this.schemaValidator = schemaValidator;
    }

    @Override
    public void migrate(IndexMetadata indexMetadata, ElasticsearchIndexLifecycleExecutionOptions executionOptions) {
        URLEncodedString indexName = indexMetadata.getName();
        URLEncodedString typeName = indexMetadata.getTypeName();
        IndexSettings settings = indexMetadata.getSettings();
        try {
            if (!settings.isEmpty() && !this.schemaValidator.isSettingsValid(indexMetadata, executionOptions)) {
                this.schemaAccessor.closeIndex(indexName);
                try {
                    this.schemaAccessor.updateSettings(indexName, settings);
                }
                catch (RuntimeException mainException) {
                    try {
                        this.schemaAccessor.openIndex(indexName);
                    }
                    catch (RuntimeException e) {
                        mainException.addSuppressed(e);
                    }
                    throw mainException;
                }
                this.schemaAccessor.openIndex(indexName);
            }
            this.schemaAccessor.putMapping(indexName, typeName, indexMetadata.getMapping());
        }
        catch (SearchException e) {
            throw log.schemaUpdateFailed(indexName, (Exception)((Object)e));
        }
    }
}

