/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.index.admin.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.hibernate.search.backend.elasticsearch.analysis.model.impl.esnative.AnalysisDefinition;
import org.hibernate.search.backend.elasticsearch.analysis.model.impl.esnative.AnalyzerDefinition;
import org.hibernate.search.backend.elasticsearch.analysis.model.impl.esnative.CharFilterDefinition;
import org.hibernate.search.backend.elasticsearch.analysis.model.impl.esnative.NormalizerDefinition;
import org.hibernate.search.backend.elasticsearch.analysis.model.impl.esnative.TokenFilterDefinition;
import org.hibernate.search.backend.elasticsearch.analysis.model.impl.esnative.TokenizerDefinition;
import org.hibernate.search.backend.elasticsearch.document.model.impl.esnative.AbstractTypeMapping;
import org.hibernate.search.backend.elasticsearch.document.model.impl.esnative.DataType;
import org.hibernate.search.backend.elasticsearch.document.model.impl.esnative.DynamicType;
import org.hibernate.search.backend.elasticsearch.document.model.impl.esnative.FieldDataType;
import org.hibernate.search.backend.elasticsearch.document.model.impl.esnative.IndexType;
import org.hibernate.search.backend.elasticsearch.document.model.impl.esnative.NormsType;
import org.hibernate.search.backend.elasticsearch.document.model.impl.esnative.PropertyMapping;
import org.hibernate.search.backend.elasticsearch.document.model.impl.esnative.RootTypeMapping;
import org.hibernate.search.backend.elasticsearch.index.admin.gson.impl.AnalysisJsonElementEquivalence;
import org.hibernate.search.backend.elasticsearch.index.admin.gson.impl.AnalysisParameterEquivalenceRegistry;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ElasticsearchIndexLifecycleExecutionOptions;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ElasticsearchSchemaAccessor;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ElasticsearchSchemaValidator;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ElasticsearchValidationMessages;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.IndexMetadata;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ValidationContext;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ValidationContextElement;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ValidationContextType;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ValidationErrorCollector;
import org.hibernate.search.backend.elasticsearch.index.settings.impl.esnative.Analysis;
import org.hibernate.search.backend.elasticsearch.index.settings.impl.esnative.IndexSettings;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.util.AssertionFailure;
import org.hibernate.search.util.impl.common.CollectionHelper;
import org.hibernate.search.util.impl.common.LoggerFactory;
import org.jboss.logging.Messages;

public class ElasticsearchSchemaValidatorImpl
implements ElasticsearchSchemaValidator {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final ElasticsearchValidationMessages MESSAGES = (ElasticsearchValidationMessages)Messages.getBundle(ElasticsearchValidationMessages.class);
    private static final AnalysisParameterEquivalenceRegistry NORMALIZER_EQUIVALENCES = new AnalysisParameterEquivalenceRegistry.Builder().build();
    private final Validator<NormalizerDefinition> normalizerDefinitionValidator = new NormalizerDefinitionValidator(NORMALIZER_EQUIVALENCES);
    private static final double DEFAULT_DOUBLE_DELTA = 0.001;
    private static final float DEFAULT_FLOAT_DELTA = 0.001f;
    private static final List<String> DEFAULT_DATE_FORMAT;
    private static final AnalysisParameterEquivalenceRegistry ANALYZER_EQUIVALENCES;
    private static final AnalysisParameterEquivalenceRegistry CHAR_FILTER_EQUIVALENCES;
    private static final AnalysisParameterEquivalenceRegistry TOKENIZER_EQUIVALENCES;
    private static final AnalysisParameterEquivalenceRegistry TOKEN_FILTER_EQUIVALENCES;
    private final ElasticsearchSchemaAccessor schemaAccessor;
    private final Validator<RootTypeMapping> rootTypeMappingValidator = new RootTypeMappingValidator(new PropertyMappingValidator());
    private final Validator<AnalyzerDefinition> analyzerDefinitionValidator = new AnalyzerDefinitionValidator(ANALYZER_EQUIVALENCES);
    private final Validator<CharFilterDefinition> charFilterDefinitionValidator = new AnalysisDefinitionValidator<CharFilterDefinition>(CHAR_FILTER_EQUIVALENCES);
    private final Validator<TokenizerDefinition> tokenizerDefinitionValidator = new AnalysisDefinitionValidator<TokenizerDefinition>(TOKENIZER_EQUIVALENCES);
    private final Validator<TokenFilterDefinition> tokenFilterDefinitionValidator = new AnalysisDefinitionValidator<TokenFilterDefinition>(TOKEN_FILTER_EQUIVALENCES);

    public ElasticsearchSchemaValidatorImpl(ElasticsearchSchemaAccessor schemaAccessor) {
        this.schemaAccessor = schemaAccessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validate(IndexMetadata expectedIndexMetadata, ElasticsearchIndexLifecycleExecutionOptions executionOptions) {
        URLEncodedString indexName = expectedIndexMetadata.getName();
        URLEncodedString typeName = expectedIndexMetadata.getTypeName();
        IndexMetadata actualIndexMetadata = this.schemaAccessor.getCurrentIndexMetadata(indexName, typeName);
        ValidationErrorCollector errorCollector = new ValidationErrorCollector();
        errorCollector.push(ValidationContextType.INDEX, indexName.original);
        try {
            this.validate(errorCollector, expectedIndexMetadata, actualIndexMetadata);
        }
        finally {
            errorCollector.pop();
        }
        Map<ValidationContext, List<String>> messagesByContext = errorCollector.getMessagesByContext();
        if (messagesByContext.isEmpty()) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<ValidationContext, List<String>> entry : messagesByContext.entrySet()) {
            ValidationContext context = entry.getKey();
            List<String> messages = entry.getValue();
            builder.append("\n").append(this.formatContext(context));
            for (String message : messages) {
                builder.append("\n\t").append(message);
            }
        }
        throw log.schemaValidationFailed(builder.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSettingsValid(IndexMetadata expectedIndexMetadata, ElasticsearchIndexLifecycleExecutionOptions executionOptions) {
        URLEncodedString indexName = expectedIndexMetadata.getName();
        URLEncodedString typeName = expectedIndexMetadata.getTypeName();
        IndexMetadata actualIndexMetadata = this.schemaAccessor.getCurrentIndexMetadata(indexName, typeName);
        ValidationErrorCollector errorCollector = new ValidationErrorCollector();
        errorCollector.push(ValidationContextType.INDEX, indexName.original);
        try {
            this.validateIndexSettings(errorCollector, expectedIndexMetadata.getSettings(), actualIndexMetadata.getSettings());
        }
        finally {
            errorCollector.pop();
        }
        return errorCollector.getMessagesByContext().isEmpty();
    }

    private String formatContext(ValidationContext context) {
        StringBuilder builder = new StringBuilder();
        StringBuilder pathBuilder = new StringBuilder();
        for (ValidationContextElement element : context.getElements()) {
            String name = element.getName();
            if (ValidationContextType.MAPPING_PROPERTY.equals((Object)element.getType())) {
                if (pathBuilder.length() > 0) {
                    pathBuilder.append(".");
                }
                pathBuilder.append(name);
                continue;
            }
            if (pathBuilder.length() > 0) {
                this.appendContextElement(builder, ValidationContextType.MAPPING_PROPERTY, pathBuilder.toString());
                pathBuilder.setLength(0);
            }
            this.appendContextElement(builder, element.getType(), element.getName());
        }
        if (pathBuilder.length() > 0) {
            this.appendContextElement(builder, ValidationContextType.MAPPING_PROPERTY, pathBuilder.toString());
        }
        builder.append(":");
        return builder.toString();
    }

    private void appendContextElement(StringBuilder builder, ValidationContextType type, String name) {
        String formatted = this.formatContextElement(type, name);
        if (builder.length() > 0) {
            builder.append(", ");
        }
        builder.append(formatted);
    }

    private String formatContextElement(ValidationContextType type, String name) {
        switch (type) {
            case INDEX: {
                return MESSAGES.indexContext(name);
            }
            case MAPPING_PROPERTY: {
                return MESSAGES.mappingPropertyContext(name);
            }
            case MAPPING_PROPERTY_FIELD: {
                return MESSAGES.mappingPropertyFieldContext(name);
            }
            case ANALYZER: {
                return MESSAGES.analyzerContext(name);
            }
            case CHAR_FILTER: {
                return MESSAGES.charFilterContext(name);
            }
            case TOKENIZER: {
                return MESSAGES.tokenizerContext(name);
            }
            case TOKEN_FILTER: {
                return MESSAGES.tokenFilterContext(name);
            }
            case NORMALIZER: {
                return MESSAGES.normalizerContext(name);
            }
        }
        throw new AssertionFailure("Unexpected validation context element type: " + (Object)((Object)type));
    }

    private void validate(ValidationErrorCollector errorCollector, IndexMetadata expectedIndexMetadata, IndexMetadata actualIndexMetadata) {
        this.validateIndexSettings(errorCollector, expectedIndexMetadata.getSettings(), actualIndexMetadata.getSettings());
        RootTypeMapping expectedRootMapping = expectedIndexMetadata.getMapping();
        RootTypeMapping actualRootMapping = actualIndexMetadata.getMapping();
        if (expectedRootMapping == null) {
            return;
        }
        if (actualRootMapping == null) {
            errorCollector.addError(MESSAGES.mappingMissing(expectedIndexMetadata.getTypeName().original));
            return;
        }
        this.rootTypeMappingValidator.validate(errorCollector, expectedRootMapping, actualRootMapping);
    }

    private void validateIndexSettings(ValidationErrorCollector errorCollector, IndexSettings expectedSettings, IndexSettings actualSettings) {
        Analysis expectedAnalysis = expectedSettings.getAnalysis();
        if (expectedAnalysis == null) {
            return;
        }
        Analysis actualAnalysis = actualSettings.getAnalysis();
        this.validateAnalysisSettings(errorCollector, expectedAnalysis, actualAnalysis);
    }

    private void validateAnalysisSettings(ValidationErrorCollector errorCollector, Analysis expectedAnalysis, Analysis actualAnalysis) {
        this.validateAll(errorCollector, ValidationContextType.ANALYZER, MESSAGES.analyzerMissing(), this.analyzerDefinitionValidator, expectedAnalysis.getAnalyzers(), actualAnalysis == null ? null : actualAnalysis.getAnalyzers());
        this.validateAll(errorCollector, ValidationContextType.CHAR_FILTER, MESSAGES.charFilterMissing(), this.charFilterDefinitionValidator, expectedAnalysis.getCharFilters(), actualAnalysis == null ? null : actualAnalysis.getCharFilters());
        this.validateAll(errorCollector, ValidationContextType.TOKENIZER, MESSAGES.tokenizerMissing(), this.tokenizerDefinitionValidator, expectedAnalysis.getTokenizers(), actualAnalysis == null ? null : actualAnalysis.getTokenizers());
        this.validateAll(errorCollector, ValidationContextType.TOKEN_FILTER, MESSAGES.tokenFilterMissing(), this.tokenFilterDefinitionValidator, expectedAnalysis.getTokenFilters(), actualAnalysis == null ? null : actualAnalysis.getTokenFilters());
        this.validateAll(errorCollector, ValidationContextType.NORMALIZER, MESSAGES.normalizerMissing(), this.normalizerDefinitionValidator, expectedAnalysis.getNormalizers(), actualAnalysis == null ? null : actualAnalysis.getNormalizers());
    }

    private <T> void validateEqualWithDefault(ValidationErrorCollector errorCollector, String attributeName, T expectedValue, T actualValue, T defaultValueForNulls) {
        T defaultedActualValue;
        T defaultedExpectedValue = expectedValue == null ? defaultValueForNulls : expectedValue;
        T t = defaultedActualValue = actualValue == null ? defaultValueForNulls : actualValue;
        if (!Objects.equals(defaultedExpectedValue, defaultedActualValue)) {
            errorCollector.addError(MESSAGES.invalidAttributeValue(attributeName, defaultedExpectedValue, actualValue));
        }
    }

    private <T> void validateEqualWithDefault(ValidationErrorCollector errorCollector, String attributeName, Float expectedValue, Float actualValue, float delta, Float defaultValueForNulls) {
        Float defaultedActualValue;
        Float defaultedExpectedValue = expectedValue == null ? defaultValueForNulls : expectedValue;
        Float f = defaultedActualValue = actualValue == null ? defaultValueForNulls : actualValue;
        if (defaultedExpectedValue == null || defaultedActualValue == null) {
            if (defaultedExpectedValue == defaultedActualValue) {
                return;
            }
            errorCollector.addError(MESSAGES.invalidAttributeValue(attributeName, defaultedExpectedValue, actualValue));
        } else {
            if (Float.compare(defaultedExpectedValue.floatValue(), defaultedActualValue.floatValue()) == 0) {
                return;
            }
            if (Math.abs(defaultedExpectedValue.floatValue() - defaultedActualValue.floatValue()) > delta) {
                errorCollector.addError(MESSAGES.invalidAttributeValue(attributeName, defaultedExpectedValue, actualValue));
            }
        }
    }

    private <T> void validateEqualWithDefault(ValidationErrorCollector errorCollector, String attributeName, Double expectedValue, Double actualValue, double delta, Double defaultValueForNulls) {
        Double defaultedActualValue;
        Double defaultedExpectedValue = expectedValue == null ? defaultValueForNulls : expectedValue;
        Double d = defaultedActualValue = actualValue == null ? defaultValueForNulls : actualValue;
        if (defaultedExpectedValue == null || defaultedActualValue == null) {
            if (defaultedExpectedValue == defaultedActualValue) {
                return;
            }
            errorCollector.addError(MESSAGES.invalidAttributeValue(attributeName, defaultedExpectedValue, actualValue));
        }
        if (Double.compare(defaultedExpectedValue, defaultedActualValue) == 0) {
            return;
        }
        if (Math.abs(defaultedExpectedValue - defaultedActualValue) > delta) {
            errorCollector.addError(MESSAGES.invalidAttributeValue(attributeName, defaultedExpectedValue, actualValue));
        }
    }

    private <T> void validateFormatWithDefault(ValidationErrorCollector errorCollector, String attributeName, List<String> expectedValue, List<String> actualValue, List<String> defaultValueForNulls) {
        String actualOutputFormat;
        List<String> defaultedActualValue;
        List<String> defaultedExpectedValue = expectedValue == null ? defaultValueForNulls : expectedValue;
        List<String> list = defaultedActualValue = actualValue == null ? defaultValueForNulls : actualValue;
        if (defaultedExpectedValue.isEmpty()) {
            return;
        }
        String expectedOutputFormat = defaultedExpectedValue.get(0);
        String string = actualOutputFormat = defaultedActualValue.isEmpty() ? null : defaultedActualValue.get(0);
        if (!Objects.equals(expectedOutputFormat, actualOutputFormat)) {
            errorCollector.addError(MESSAGES.invalidOutputFormat(attributeName, expectedOutputFormat, actualOutputFormat));
        }
        ArrayList<String> missingFormats = new ArrayList<String>();
        missingFormats.addAll(defaultedExpectedValue);
        missingFormats.removeAll(defaultedActualValue);
        ArrayList<String> unexpectedFormats = new ArrayList<String>();
        unexpectedFormats.addAll(defaultedActualValue);
        unexpectedFormats.removeAll(defaultedExpectedValue);
        if (!missingFormats.isEmpty() || !unexpectedFormats.isEmpty()) {
            errorCollector.addError(MESSAGES.invalidInputFormat(attributeName, defaultedExpectedValue, defaultedActualValue, missingFormats, unexpectedFormats));
        }
    }

    private void validateJsonPrimitive(ValidationErrorCollector errorCollector, DataType type, String attributeName, JsonPrimitive expectedValue, JsonPrimitive actualValue) {
        DataType defaultedType = type == null ? DataType.OBJECT : type;
        this.doValidateJsonPrimitive(errorCollector, defaultedType, attributeName, expectedValue, actualValue);
    }

    private void doValidateJsonPrimitive(ValidationErrorCollector errorCollector, DataType type, String attributeName, JsonPrimitive expectedValue, JsonPrimitive actualValue) {
        switch (type) {
            case TEXT: 
            case KEYWORD: {
                this.validateEqualWithDefault(errorCollector, attributeName, expectedValue, actualValue, null);
                break;
            }
            case DOUBLE: {
                if (expectedValue.isNumber() && actualValue.isNumber()) {
                    this.validateEqualWithDefault(errorCollector, attributeName, expectedValue.getAsDouble(), actualValue.getAsDouble(), 0.001, null);
                    break;
                }
                errorCollector.addError(MESSAGES.invalidAttributeValue(attributeName, expectedValue, actualValue));
                break;
            }
            case FLOAT: {
                if (expectedValue.isNumber() && actualValue.isNumber()) {
                    this.validateEqualWithDefault(errorCollector, attributeName, Float.valueOf(expectedValue.getAsFloat()), Float.valueOf(actualValue.getAsFloat()), 0.001f, null);
                    break;
                }
                errorCollector.addError(MESSAGES.invalidAttributeValue(attributeName, expectedValue, actualValue));
                break;
            }
            default: {
                this.validateEqualWithDefault(errorCollector, attributeName, expectedValue, actualValue, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void validateAll(ValidationErrorCollector errorCollector, ValidationContextType type, String messageIfMissing, Validator<T> validator, Map<String, T> expectedMap, Map<String, T> actualMap) {
        if (expectedMap == null || expectedMap.isEmpty()) {
            return;
        }
        if (actualMap == null) {
            actualMap = Collections.emptyMap();
        }
        for (Map.Entry<String, T> entry : expectedMap.entrySet()) {
            String name = entry.getKey();
            T expected = entry.getValue();
            Object actual = actualMap.get(name);
            errorCollector.push(type, name);
            try {
                if (actual == null) {
                    errorCollector.addError(messageIfMissing);
                    continue;
                }
                validator.validate(errorCollector, expected, actual);
            }
            finally {
                errorCollector.pop();
            }
        }
    }

    private void validateIndexOptions(ValidationErrorCollector errorCollector, PropertyMapping expectedMapping, PropertyMapping actualMapping) {
        Boolean expectedDocValues;
        FieldDataType expectedFieldData;
        NormsType expectedNorms;
        IndexType expectedIndex = expectedMapping.getIndex();
        if (IndexType.TRUE.equals((Object)expectedIndex)) {
            IndexType indexDefault = IndexType.TRUE;
            this.validateEqualWithDefault(errorCollector, "index", expectedIndex, actualMapping.getIndex(), indexDefault);
        }
        if (NormsType.TRUE.equals((Object)(expectedNorms = expectedMapping.getNorms()))) {
            NormsType normsDefault = DataType.TEXT.equals((Object)expectedMapping.getType()) ? NormsType.TRUE : NormsType.FALSE;
            this.validateEqualWithDefault(errorCollector, "norms", expectedNorms, actualMapping.getNorms(), normsDefault);
        }
        if (FieldDataType.TRUE.equals((Object)(expectedFieldData = expectedMapping.getFieldData()))) {
            this.validateEqualWithDefault(errorCollector, "fielddata", expectedFieldData, actualMapping.getFieldData(), FieldDataType.FALSE);
        }
        if (Boolean.TRUE.equals(expectedDocValues = expectedMapping.getDocValues())) {
            this.validateEqualWithDefault(errorCollector, "doc_values", expectedDocValues, actualMapping.getDocValues(), false);
        }
    }

    private void validateAnalyzerOptions(ValidationErrorCollector errorCollector, PropertyMapping expectedMapping, PropertyMapping actualMapping) {
        this.validateEqualWithDefault(errorCollector, "analyzer", expectedMapping.getAnalyzer(), actualMapping.getAnalyzer(), "default");
        this.validateEqualWithDefault(errorCollector, "normalizer", expectedMapping.getNormalizer(), actualMapping.getNormalizer(), null);
    }

    static {
        ArrayList<String> formats = new ArrayList<String>();
        formats.add("strict_date_optional_time");
        formats.add("epoch_millis");
        DEFAULT_DATE_FORMAT = CollectionHelper.toImmutableList(formats);
        ANALYZER_EQUIVALENCES = new AnalysisParameterEquivalenceRegistry.Builder().type("keep_types").param("types").unorderedArray().end().build();
        CHAR_FILTER_EQUIVALENCES = new AnalysisParameterEquivalenceRegistry.Builder().build();
        TOKENIZER_EQUIVALENCES = new AnalysisParameterEquivalenceRegistry.Builder().type("edgeNGram").param("token_chars").unorderedArray().end().type("nGram").param("token_chars").unorderedArray().end().type("stop").param("stopwords").unorderedArray().end().type("word_delimiter").param("protected_words").unorderedArray().end().type("keyword_marker").param("keywords").unorderedArray().end().type("pattern_capture").param("patterns").unorderedArray().end().type("common_grams").param("common_words").unorderedArray().end().type("cjk_bigram").param("ignored_scripts").unorderedArray().end().build();
        TOKEN_FILTER_EQUIVALENCES = new AnalysisParameterEquivalenceRegistry.Builder().type("keep_types").param("types").unorderedArray().end().build();
    }

    private class NormalizerDefinitionValidator
    extends AnalysisDefinitionValidator<NormalizerDefinition> {
        NormalizerDefinitionValidator(AnalysisParameterEquivalenceRegistry equivalences) {
            super(equivalences);
        }

        @Override
        public void validate(ValidationErrorCollector errorCollector, NormalizerDefinition expectedDefinition, NormalizerDefinition actualDefinition) {
            super.validate(errorCollector, expectedDefinition, actualDefinition);
            if (!Objects.equals(expectedDefinition.getCharFilters(), actualDefinition.getCharFilters())) {
                errorCollector.addError(MESSAGES.invalidAnalyzerCharFilters(expectedDefinition.getCharFilters(), actualDefinition.getCharFilters()));
            }
            if (!Objects.equals(expectedDefinition.getTokenFilters(), actualDefinition.getTokenFilters())) {
                errorCollector.addError(MESSAGES.invalidAnalyzerTokenFilters(expectedDefinition.getTokenFilters(), actualDefinition.getTokenFilters()));
            }
        }

        @Override
        protected String getDefaultType() {
            return "custom";
        }
    }

    private class PropertyMappingValidator
    extends AbstractTypeMappingValidator<PropertyMapping> {
        private PropertyMappingValidator() {
        }

        @Override
        protected Validator<PropertyMapping> getPropertyMappingValidator() {
            return this;
        }

        @Override
        public void validate(ValidationErrorCollector errorCollector, PropertyMapping expectedMapping, PropertyMapping actualMapping) {
            ElasticsearchSchemaValidatorImpl.this.validateEqualWithDefault(errorCollector, "type", (Object)expectedMapping.getType(), (Object)actualMapping.getType(), (Object)DataType.OBJECT);
            List formatDefault = DataType.DATE.equals((Object)expectedMapping.getType()) ? DEFAULT_DATE_FORMAT : Collections.emptyList();
            ElasticsearchSchemaValidatorImpl.this.validateFormatWithDefault(errorCollector, "format", expectedMapping.getFormat(), actualMapping.getFormat(), formatDefault);
            ElasticsearchSchemaValidatorImpl.this.validateEqualWithDefault(errorCollector, "boost", expectedMapping.getBoost(), actualMapping.getBoost(), 0.001f, Float.valueOf(1.0f));
            ElasticsearchSchemaValidatorImpl.this.validateIndexOptions(errorCollector, expectedMapping, actualMapping);
            Boolean expectedStore = expectedMapping.getStore();
            if (Boolean.TRUE.equals(expectedStore)) {
                ElasticsearchSchemaValidatorImpl.this.validateEqualWithDefault(errorCollector, "store", expectedStore, actualMapping.getStore(), false);
            }
            ElasticsearchSchemaValidatorImpl.this.validateJsonPrimitive(errorCollector, expectedMapping.getType(), "null_value", expectedMapping.getNullValue(), actualMapping.getNullValue());
            ElasticsearchSchemaValidatorImpl.this.validateAnalyzerOptions(errorCollector, expectedMapping, actualMapping);
            super.validate(errorCollector, expectedMapping, actualMapping);
            ElasticsearchSchemaValidatorImpl.this.validateAll(errorCollector, ValidationContextType.MAPPING_PROPERTY_FIELD, MESSAGES.propertyFieldMissing(), this.getPropertyMappingValidator(), expectedMapping.getFields(), actualMapping.getFields());
        }
    }

    private class RootTypeMappingValidator
    extends AbstractTypeMappingValidator<RootTypeMapping> {
        private final Validator<PropertyMapping> propertyMappingValidator;

        RootTypeMappingValidator(Validator<PropertyMapping> propertyMappingValidator) {
            this.propertyMappingValidator = propertyMappingValidator;
        }

        @Override
        protected Validator<PropertyMapping> getPropertyMappingValidator() {
            return this.propertyMappingValidator;
        }
    }

    private abstract class AbstractTypeMappingValidator<T extends AbstractTypeMapping>
    implements Validator<T> {
        private AbstractTypeMappingValidator() {
        }

        protected abstract Validator<PropertyMapping> getPropertyMappingValidator();

        @Override
        public void validate(ValidationErrorCollector errorCollector, T expectedMapping, T actualMapping) {
            DynamicType expectedDynamic = ((AbstractTypeMapping)expectedMapping).getDynamic();
            if (expectedDynamic != null) {
                ElasticsearchSchemaValidatorImpl.this.validateEqualWithDefault(errorCollector, "dynamic", (Object)expectedDynamic, (Object)((AbstractTypeMapping)actualMapping).getDynamic(), (Object)DynamicType.TRUE);
            }
            ElasticsearchSchemaValidatorImpl.this.validateAll(errorCollector, ValidationContextType.MAPPING_PROPERTY, MESSAGES.propertyMissing(), this.getPropertyMappingValidator(), ((AbstractTypeMapping)expectedMapping).getProperties(), ((AbstractTypeMapping)actualMapping).getProperties());
        }
    }

    private class AnalyzerDefinitionValidator
    extends AnalysisDefinitionValidator<AnalyzerDefinition> {
        AnalyzerDefinitionValidator(AnalysisParameterEquivalenceRegistry equivalences) {
            super(equivalences);
        }

        @Override
        public void validate(ValidationErrorCollector errorCollector, AnalyzerDefinition expectedDefinition, AnalyzerDefinition actualDefinition) {
            super.validate(errorCollector, expectedDefinition, actualDefinition);
            if (!Objects.equals(expectedDefinition.getCharFilters(), actualDefinition.getCharFilters())) {
                errorCollector.addError(MESSAGES.invalidAnalyzerCharFilters(expectedDefinition.getCharFilters(), actualDefinition.getCharFilters()));
            }
            if (!Objects.equals(expectedDefinition.getTokenizer(), actualDefinition.getTokenizer())) {
                errorCollector.addError(MESSAGES.invalidAnalyzerTokenizer(expectedDefinition.getTokenizer(), actualDefinition.getTokenizer()));
            }
            if (!Objects.equals(expectedDefinition.getTokenFilters(), actualDefinition.getTokenFilters())) {
                errorCollector.addError(MESSAGES.invalidAnalyzerTokenFilters(expectedDefinition.getTokenFilters(), actualDefinition.getTokenFilters()));
            }
        }

        @Override
        protected String getDefaultType() {
            return "custom";
        }
    }

    class AnalysisDefinitionValidator<T extends AnalysisDefinition>
    implements Validator<T> {
        private final AnalysisParameterEquivalenceRegistry equivalences;

        AnalysisDefinitionValidator(AnalysisParameterEquivalenceRegistry equivalences) {
            this.equivalences = equivalences;
        }

        @Override
        public void validate(ValidationErrorCollector errorCollector, T expectedDefinition, T actualDefinition) {
            Map<String, Object> actualParameters;
            Map<String, Object> expectedParameters;
            String defaultedActualType;
            String expectedType = ((AnalysisDefinition)expectedDefinition).getType();
            String actualType = ((AnalysisDefinition)actualDefinition).getType();
            String defaultedExpectedType = expectedType == null ? this.getDefaultType() : expectedType;
            String string = defaultedActualType = actualType == null ? this.getDefaultType() : actualType;
            if (!Objects.equals(defaultedExpectedType, defaultedActualType)) {
                errorCollector.addError(MESSAGES.invalidAnalysisDefinitionType(expectedType, actualType));
            }
            if ((expectedParameters = ((AnalysisDefinition)expectedDefinition).getParameters()) == null) {
                expectedParameters = Collections.emptyMap();
            }
            if ((actualParameters = ((AnalysisDefinition)actualDefinition).getParameters()) == null) {
                actualParameters = Collections.emptyMap();
            }
            HashSet<String> parametersToValidate = new HashSet<String>();
            parametersToValidate.addAll(expectedParameters.keySet());
            parametersToValidate.addAll(actualParameters.keySet());
            String typeName = ((AnalysisDefinition)expectedDefinition).getType();
            for (String parameterName : parametersToValidate) {
                JsonElement expected = (JsonElement)expectedParameters.get(parameterName);
                JsonElement actual = (JsonElement)actualParameters.get(parameterName);
                AnalysisJsonElementEquivalence parameterEquivalence = this.equivalences.get(typeName, parameterName);
                if (parameterEquivalence.isEquivalent(expected, actual)) continue;
                errorCollector.addError(MESSAGES.invalidAnalysisDefinitionParameter(parameterName, expected, actual));
            }
        }

        protected String getDefaultType() {
            return null;
        }
    }

    static interface Validator<T> {
        public void validate(ValidationErrorCollector var1, T var2, T var3);
    }
}

