/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.index.admin.impl;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ValidationContext;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ValidationContextElement;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ValidationContextType;

final class ValidationErrorCollector {
    private final Deque<ValidationContextElement> currentContext = new ArrayDeque<ValidationContextElement>();
    private final Map<ValidationContext, List<String>> messagesByContext = new LinkedHashMap<ValidationContext, List<String>>();

    ValidationErrorCollector() {
    }

    public void push(ValidationContextType contextType, String name) {
        this.currentContext.addLast(new ValidationContextElement(contextType, name));
    }

    public void pop() {
        this.currentContext.removeLast();
    }

    public void addError(String errorMessage) {
        ValidationContext context = new ValidationContext(this.currentContext);
        List<String> messages = this.messagesByContext.get(context);
        if (messages == null) {
            messages = new ArrayList<String>();
            this.messagesByContext.put(context, messages);
        }
        messages.add(errorMessage);
    }

    public Map<ValidationContext, List<String>> getMessagesByContext() {
        return this.messagesByContext;
    }
}

