/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.index.impl;

import org.hibernate.search.backend.elasticsearch.document.impl.ElasticsearchDocumentObjectBuilder;
import org.hibernate.search.backend.elasticsearch.document.model.dsl.impl.ElasticsearchIndexSchemaRootNodeBuilder;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexModel;
import org.hibernate.search.backend.elasticsearch.index.impl.ElasticsearchIndexManagerImpl;
import org.hibernate.search.backend.elasticsearch.index.impl.IndexingBackendContext;
import org.hibernate.search.backend.elasticsearch.index.management.impl.ElasticsearchIndexLifecycleStrategy;
import org.hibernate.search.backend.elasticsearch.index.settings.impl.ElasticsearchIndexSettingsBuilder;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.search.query.impl.SearchBackendContext;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexSchemaRootNodeBuilder;
import org.hibernate.search.engine.backend.index.spi.IndexManagerBuilder;
import org.hibernate.search.util.impl.common.SuppressingCloser;

public class ElasticsearchIndexManagerBuilder
implements IndexManagerBuilder<ElasticsearchDocumentObjectBuilder> {
    public static final String TYPE_NAME = "typeName";
    private final IndexingBackendContext indexingBackendContext;
    private final SearchBackendContext searchBackendContext;
    private final String hibernateSearchIndexName;
    private final String elasticsearchIndexName;
    private final ElasticsearchIndexSchemaRootNodeBuilder schemaRootNodeBuilder;
    private final ElasticsearchIndexSettingsBuilder settingsBuilder;
    private final ElasticsearchIndexLifecycleStrategy indexLifecycleStrategy;
    private final boolean refreshAfterWrite;

    public ElasticsearchIndexManagerBuilder(IndexingBackendContext indexingBackendContext, SearchBackendContext searchBackendContext, String hibernateSearchIndexName, String elasticsearchIndexName, ElasticsearchIndexSchemaRootNodeBuilder schemaRootNodeBuilder, ElasticsearchIndexSettingsBuilder settingsBuilder, ElasticsearchIndexLifecycleStrategy indexLifecycleStrategy, boolean refreshAfterWrite) {
        this.indexingBackendContext = indexingBackendContext;
        this.searchBackendContext = searchBackendContext;
        this.hibernateSearchIndexName = hibernateSearchIndexName;
        this.elasticsearchIndexName = elasticsearchIndexName;
        this.schemaRootNodeBuilder = schemaRootNodeBuilder;
        this.settingsBuilder = settingsBuilder;
        this.indexLifecycleStrategy = indexLifecycleStrategy;
        this.refreshAfterWrite = refreshAfterWrite;
    }

    public void closeOnFailure() {
    }

    public IndexSchemaRootNodeBuilder getSchemaRootNodeBuilder() {
        return this.schemaRootNodeBuilder;
    }

    public ElasticsearchIndexManagerImpl build() {
        URLEncodedString encodedElasticsearchIndexName = URLEncodedString.fromString(this.elasticsearchIndexName);
        URLEncodedString encodedTypeName = URLEncodedString.fromString(TYPE_NAME);
        ElasticsearchIndexModel model = this.schemaRootNodeBuilder.build(this.hibernateSearchIndexName, encodedElasticsearchIndexName, this.settingsBuilder);
        ElasticsearchWorkOrchestrator parallelOrchestrator = null;
        ElasticsearchWorkOrchestrator serialOrchestrator = null;
        ElasticsearchIndexManagerImpl indexManager = null;
        try {
            parallelOrchestrator = this.indexingBackendContext.createParallelOrchestrator(this.elasticsearchIndexName);
            serialOrchestrator = this.indexingBackendContext.createSerialOrchestrator(this.elasticsearchIndexName, this.refreshAfterWrite);
            indexManager = new ElasticsearchIndexManagerImpl(this.indexingBackendContext, this.searchBackendContext, this.hibernateSearchIndexName, encodedElasticsearchIndexName, encodedTypeName, model, this.indexLifecycleStrategy, serialOrchestrator, parallelOrchestrator, this.refreshAfterWrite);
            indexManager.start();
            return indexManager;
        }
        catch (RuntimeException e) {
            new SuppressingCloser((Throwable)e).push((AutoCloseable)parallelOrchestrator).push(serialOrchestrator).push(indexManager);
            throw e;
        }
    }
}

