/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.index.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.hibernate.search.backend.elasticsearch.document.impl.ElasticsearchDocumentObjectBuilder;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexModel;
import org.hibernate.search.backend.elasticsearch.index.ElasticsearchIndexManager;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ElasticsearchIndexAdministrationClient;
import org.hibernate.search.backend.elasticsearch.index.impl.ElasticsearchIndexSearchTargetContextBuilder;
import org.hibernate.search.backend.elasticsearch.index.impl.IndexingBackendContext;
import org.hibernate.search.backend.elasticsearch.index.management.impl.ElasticsearchIndexLifecycleStrategy;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.search.query.impl.SearchBackendContext;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.engine.backend.index.IndexManager;
import org.hibernate.search.engine.backend.index.spi.IndexDocumentWorkExecutor;
import org.hibernate.search.engine.backend.index.spi.IndexManagerImplementor;
import org.hibernate.search.engine.backend.index.spi.IndexSearchTargetContextBuilder;
import org.hibernate.search.engine.backend.index.spi.IndexWorkExecutor;
import org.hibernate.search.engine.backend.index.spi.IndexWorkPlan;
import org.hibernate.search.engine.logging.spi.EventContexts;
import org.hibernate.search.engine.mapper.mapping.context.spi.MappingContextImplementor;
import org.hibernate.search.engine.mapper.session.context.spi.SessionContextImplementor;
import org.hibernate.search.util.EventContext;
import org.hibernate.search.util.impl.common.Closer;
import org.hibernate.search.util.impl.common.LoggerFactory;

class ElasticsearchIndexManagerImpl
implements IndexManagerImplementor<ElasticsearchDocumentObjectBuilder>,
ElasticsearchIndexManager {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final IndexingBackendContext indexingBackendContext;
    private final SearchBackendContext searchBackendContext;
    private final String hibernateSearchIndexName;
    private final URLEncodedString elasticsearchIndexName;
    private final URLEncodedString typeName;
    private final ElasticsearchIndexModel model;
    private final ElasticsearchWorkOrchestrator serialOrchestrator;
    private final ElasticsearchWorkOrchestrator parallelOrchestrator;
    private final boolean refreshAfterWrite;
    private final ElasticsearchIndexLifecycleStrategy managementStrategy;
    private final ElasticsearchIndexAdministrationClient administrationClient;

    ElasticsearchIndexManagerImpl(IndexingBackendContext indexingBackendContext, SearchBackendContext searchBackendContext, String hibernateSearchIndexName, URLEncodedString elasticsearchIndexName, URLEncodedString typeName, ElasticsearchIndexModel model, ElasticsearchIndexLifecycleStrategy managementStrategy, ElasticsearchWorkOrchestrator serialOrchestrator, ElasticsearchWorkOrchestrator parallelOrchestrator, boolean refreshAfterWrite) {
        this.indexingBackendContext = indexingBackendContext;
        this.searchBackendContext = searchBackendContext;
        this.hibernateSearchIndexName = hibernateSearchIndexName;
        this.elasticsearchIndexName = elasticsearchIndexName;
        this.typeName = typeName;
        this.model = model;
        this.serialOrchestrator = serialOrchestrator;
        this.parallelOrchestrator = parallelOrchestrator;
        this.refreshAfterWrite = refreshAfterWrite;
        this.managementStrategy = managementStrategy;
        this.administrationClient = indexingBackendContext.createAdministrationClient(elasticsearchIndexName, typeName, model);
    }

    public void start() {
        this.managementStrategy.onStart(this.administrationClient);
    }

    public void close() {
        try (Closer closer = new Closer();){
            closer.push(ElasticsearchWorkOrchestrator::close, (Object)this.serialOrchestrator);
            closer.push(ElasticsearchWorkOrchestrator::close, (Object)this.parallelOrchestrator);
            closer.push(strategy -> strategy.onStop(this.administrationClient), (Object)this.managementStrategy);
        }
        catch (IOException e) {
            throw log.failedToShutdownIndexManager(this.hibernateSearchIndexName, e, this.indexingBackendContext.getEventContext());
        }
    }

    public ElasticsearchIndexModel getModel() {
        return this.model;
    }

    public IndexWorkPlan<ElasticsearchDocumentObjectBuilder> createWorkPlan(SessionContextImplementor sessionContext) {
        return this.indexingBackendContext.createWorkPlan(this.serialOrchestrator, this.elasticsearchIndexName, this.typeName, this.refreshAfterWrite, sessionContext);
    }

    public IndexDocumentWorkExecutor<ElasticsearchDocumentObjectBuilder> createDocumentWorkExecutor(SessionContextImplementor sessionContext) {
        return this.indexingBackendContext.createDocumentWorkExecutor(this.parallelOrchestrator, this.elasticsearchIndexName, this.typeName, sessionContext);
    }

    public IndexWorkExecutor createWorkExecutor() {
        return this.indexingBackendContext.createWorkExecutor(this.parallelOrchestrator, this.elasticsearchIndexName);
    }

    public IndexSearchTargetContextBuilder createSearchTargetContextBuilder(MappingContextImplementor mappingContext) {
        return new ElasticsearchIndexSearchTargetContextBuilder(this.searchBackendContext, mappingContext, this);
    }

    public void addToSearchTarget(IndexSearchTargetContextBuilder searchTargetBuilder) {
        if (!(searchTargetBuilder instanceof ElasticsearchIndexSearchTargetContextBuilder)) {
            throw log.cannotMixElasticsearchSearchTargetWithOtherType(searchTargetBuilder, this, this.searchBackendContext.getEventContext());
        }
        ElasticsearchIndexSearchTargetContextBuilder esSearchTargetBuilder = (ElasticsearchIndexSearchTargetContextBuilder)searchTargetBuilder;
        esSearchTargetBuilder.add(this.searchBackendContext, this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "name=" + this.hibernateSearchIndexName + "elasticsearchName=" + this.elasticsearchIndexName.original + "]";
    }

    public IndexManager toAPI() {
        return this;
    }

    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isAssignableFrom(ElasticsearchIndexManager.class)) {
            return (T)this;
        }
        throw log.indexManagerUnwrappingWithUnknownType(clazz, ElasticsearchIndexManager.class, this.getBackendAndIndexEventContext());
    }

    private EventContext getBackendAndIndexEventContext() {
        return this.indexingBackendContext.getEventContext().append(EventContexts.fromIndexName((String)this.hibernateSearchIndexName));
    }
}

