/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.orchestration.impl;

import java.lang.invoke.MethodHandles;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchClient;
import org.hibernate.search.backend.elasticsearch.gson.spi.GsonProvider;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchImmutableWorkExecutionContext;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchRefreshableWorkExecutionContext;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.backend.elasticsearch.work.builder.factory.impl.ElasticsearchWorkBuilderFactory;
import org.hibernate.search.backend.elasticsearch.work.builder.impl.RefreshWorkBuilder;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWorkExecutionContext;
import org.hibernate.search.engine.common.spi.ErrorHandler;
import org.hibernate.search.util.impl.common.Futures;
import org.hibernate.search.util.impl.common.LoggerFactory;

class ElasticsearchDefaultWorkExecutionContext
implements ElasticsearchRefreshableWorkExecutionContext {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final ElasticsearchClient client;
    private final GsonProvider gsonProvider;
    private final ErrorHandler errorHandler;
    private final ElasticsearchWorkBuilderFactory workFactory;
    private final Set<URLEncodedString> indexesToRefresh = new HashSet<URLEncodedString>();
    private final ElasticsearchWorkExecutionContext refreshExecutionContext;

    public ElasticsearchDefaultWorkExecutionContext(ElasticsearchClient client, GsonProvider gsonProvider, ElasticsearchWorkBuilderFactory workFactory, ErrorHandler errorHandler) {
        this.client = client;
        this.gsonProvider = gsonProvider;
        this.errorHandler = errorHandler;
        this.workFactory = workFactory;
        this.refreshExecutionContext = new ElasticsearchImmutableWorkExecutionContext(client, gsonProvider);
    }

    @Override
    public ElasticsearchClient getClient() {
        return this.client;
    }

    @Override
    public GsonProvider getGsonProvider() {
        return this.gsonProvider;
    }

    @Override
    public void registerIndexToRefresh(URLEncodedString indexName) {
        this.indexesToRefresh.add(indexName);
    }

    @Override
    public CompletableFuture<Void> executePendingRefreshes() {
        CompletionStage<Object> future = CompletableFuture.completedFuture(null);
        if (!this.indexesToRefresh.isEmpty()) {
            future = ((CompletableFuture)future.thenCompose(ignored -> this.refreshIndexes())).thenRun(() -> this.indexesToRefresh.clear());
        }
        return future;
    }

    private CompletableFuture<?> refreshIndexes() {
        if (log.isTraceEnabled()) {
            log.tracef("Refreshing index(es) %s", this.indexesToRefresh);
        }
        RefreshWorkBuilder builder = this.workFactory.refresh();
        for (URLEncodedString index : this.indexesToRefresh) {
            builder.index(index);
        }
        Object work = builder.build();
        return work.execute(this.refreshExecutionContext).handle(Futures.handler((result, throwable) -> {
            if (throwable != null) {
                this.errorHandler.handleException("Refresh failed", throwable);
            }
            return null;
        }));
    }
}

