/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.orchestration.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchAccumulatingWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkBulker;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkSequenceBuilder;
import org.hibernate.search.backend.elasticsearch.work.impl.BulkableElasticsearchWork;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWork;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWorkAggregator;

class ElasticsearchParallelChangesetsWorkOrchestrator
implements ElasticsearchAccumulatingWorkOrchestrator {
    private final BulkAndSequenceAggregator aggregator;
    private final List<CompletableFuture<?>> sequenceFutures = new ArrayList();

    public ElasticsearchParallelChangesetsWorkOrchestrator(ElasticsearchWorkSequenceBuilder sequenceBuilder, ElasticsearchWorkBulker bulker) {
        this.aggregator = new BulkAndSequenceAggregator(sequenceBuilder, bulker);
    }

    public CompletableFuture<Void> submit(List<ElasticsearchWork<?>> nonBulkedWorks) {
        this.aggregator.initSequence();
        for (ElasticsearchWork<?> work : nonBulkedWorks) {
            work.aggregate(this.aggregator);
        }
        CompletableFuture<Void> future = this.aggregator.buildSequence();
        this.sequenceFutures.add(future);
        return future;
    }

    @Override
    public <T> CompletableFuture<T> submit(ElasticsearchWork<T> work) {
        this.aggregator.initSequence();
        CompletableFuture<T> workFuture = work.aggregate(this.aggregator);
        this.aggregator.buildSequence();
        return workFuture;
    }

    public CompletableFuture<Void> executeSubmitted() {
        CompletableFuture<Void> future = CompletableFuture.allOf(this.sequenceFutures.toArray(new CompletableFuture[this.sequenceFutures.size()]));
        this.sequenceFutures.clear();
        this.aggregator.startSequences();
        return future;
    }

    @Override
    public void reset() {
        this.aggregator.reset();
        this.sequenceFutures.clear();
    }

    private static class BulkAndSequenceAggregator
    implements ElasticsearchWorkAggregator {
        private final ElasticsearchWorkSequenceBuilder sequenceBuilder;
        private final ElasticsearchWorkBulker bulker;
        private CompletableFuture<Void> rootFuture = CompletableFuture.completedFuture(null);
        private boolean currentBulkIsUsableInSameSequence = true;

        public BulkAndSequenceAggregator(ElasticsearchWorkSequenceBuilder sequenceBuilder, ElasticsearchWorkBulker bulker) {
            this.sequenceBuilder = sequenceBuilder;
            this.bulker = bulker;
        }

        public void initSequence() {
            this.sequenceBuilder.init(this.rootFuture);
        }

        @Override
        public <T> CompletableFuture<T> addBulkable(BulkableElasticsearchWork<T> work) {
            if (!this.currentBulkIsUsableInSameSequence) {
                this.bulker.finalizeBulkWork();
                this.currentBulkIsUsableInSameSequence = true;
            }
            return this.bulker.add(work);
        }

        @Override
        public <T> CompletableFuture<T> addNonBulkable(ElasticsearchWork<T> work) {
            if (this.bulker.addWorksToSequence()) {
                this.currentBulkIsUsableInSameSequence = false;
            }
            return this.sequenceBuilder.addNonBulkExecution(work);
        }

        public CompletableFuture<Void> buildSequence() {
            this.bulker.addWorksToSequence();
            CompletableFuture<Void> future = this.sequenceBuilder.build();
            this.currentBulkIsUsableInSameSequence = true;
            return future;
        }

        public void startSequences() {
            this.bulker.finalizeBulkWork();
        }

        public void reset() {
            this.bulker.reset();
            this.rootFuture = CompletableFuture.completedFuture(null);
            this.sequenceBuilder.init(this.rootFuture);
        }
    }
}

